% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geodesicAreas.R
\name{mapxy}
\alias{mapxy}
\title{Get geodetic latitudes and longitudes}
\usage{
mapxy(X, Y, sgn = 1, slat = 70, re = 6378.273, e2 = 0.006693883,
  degrees = TRUE)
}
\arguments{
\item{X}{Polar Stereographic X Coordinate (km)}

\item{Y}{Polar Stereographic Y Coordinate (km)}

\item{sgn}{indicator for Northern hemisphere (defaults to 1)}

\item{slat}{standard latitude (defaults to 70)}

\item{re}{Earth's radius (defaults to 6378.273)}

\item{e2}{eccentricity squared (defaults to 0.006693883)}

\item{degrees}{boolean indicating whether result should be
returned in degrees or radians}
}
\value{
list with elements \code{coords$aLat}, the geodetic latitude
        (degrees, +90 to -90), and \code{coords$aLon}, the geodetic longitude
        (degrees, -180 to 180)
}
\description{
Get corresponding latitude and longitude values for coordinates on a Polar
Stereographic North projection grid
}
\examples{
new <- mapxy(100, 300)
new$alat
new$alon
}
\references{
The equations for this calculation are from Snyder, J. P., 1982,
            Map Projections Used by the U.S. Geological Survey, Geological
            Survey Bulletin 1532, U.S. Government Printing Office.
            See JPL Technical Memorandum 3349-85-101 for further details.
}
