/*
 * Decompiled with CFR 0.152.
 */
package sampler;

import cern.jet.random.tdouble.Gamma;
import cern.jet.random.tdouble.Normal;
import cern.jet.random.tdouble.engine.DoubleMersenneTwister;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import org.apache.commons.math3.distribution.BetaDistribution;
import utils.MathUtil;
import utils.ProgressPopup;

public class InsilicoSampler2 {
    public int N;
    public int S;
    public int C;
    public int N_sub;
    public int N_level;
    public double[][] probbase;
    public double[][] probbase_order;
    public double[] level_values;
    public HashMap<Integer, HashMap<Integer, ArrayList<Integer>>> probbase_level;
    public int[][] count_m;
    public int[][] count_m_all;
    public int[] count_c;
    public int C_phy;
    public double[] broader;
    public HashMap<Integer, HashSet<Integer>> catmap;

    public void initiate(int N, int S, int C, int N_sub, int N_level, int[] subpop, double[][] probbase, double[][] probbase_order, double[] level_values, int pool) {
        this.N = N;
        this.S = S;
        this.C = C;
        this.N_sub = N_sub;
        this.N_level = N_level;
        this.probbase = probbase;
        this.probbase_order = probbase_order;
        this.count_m = new int[S][C];
        this.count_m_all = new int[S][C];
        this.count_c = new int[C];
        this.level_values = level_values;
        this.probbase_level = new HashMap();
        this.levelize(pool);
    }

    public void initiate(int N, int S, int C, int N_sub, int N_level, int[] subpop, double[][] probbase, double[][] probbase_order, double[] level_values, int pool, int C_phy, double[] broader) {
        this.initiate(N, S, C, N_sub, N_level, subpop, probbase, probbase_order, level_values, pool);
        this.C_phy = C_phy;
        this.broader = broader;
        this.initiateCatMap();
    }

    public void initiateCatMap() {
        this.catmap = new HashMap();
        this.catmap.put(0, new HashSet());
        for (int j = 1; j < this.broader.length; ++j) {
            this.catmap.get(0).add(j);
        }
        for (int i = 1; i < this.C_phy; ++i) {
            this.catmap.put(i, new HashSet());
            for (int j = 1; j < this.broader.length; ++j) {
                if ((int)this.broader[j] != i) continue;
                this.catmap.get(i).add(j);
            }
        }
    }

    private void levelize(int pool) {
        block9: {
            block8: {
                if (!(pool == 0 | pool == 1)) break block8;
                for (int s = 0; s < this.S; ++s) {
                    for (int c = 0; c < this.C; ++c) {
                        int level = (int)this.probbase_order[s][c];
                        if (this.probbase_level.get(c) == null) {
                            this.probbase_level.put(c, new HashMap());
                        }
                        if (this.probbase_level.get(c).get(level) == null) {
                            this.probbase_level.get(c).put(level, new ArrayList());
                        }
                        this.probbase_level.get(c).get(level).add(s);
                    }
                }
                break block9;
            }
            if (pool != 2) break block9;
            for (int s = 0; s < this.S; ++s) {
                for (int c = 0; c < this.C; ++c) {
                    int level = (int)this.probbase_order[s][c];
                    if (this.probbase_level.get(s) == null) {
                        this.probbase_level.put(s, new HashMap());
                    }
                    if (this.probbase_level.get(s).get(level) == null) {
                        this.probbase_level.get(s).put(level, new ArrayList());
                    }
                    this.probbase_level.get(s).get(level).add(c);
                }
            }
        }
    }

    public void CountCurrent(double[][] indic, int[] ynew) {
        this.count_m = new int[this.S][this.C];
        this.count_m_all = new int[this.S][this.C];
        this.count_c = new int[this.C];
        for (int n = 0; n < this.N; ++n) {
            int c_current;
            int n2 = c_current = ynew[n];
            this.count_c[n2] = this.count_c[n2] + 1;
            for (int s = 0; s < this.S; ++s) {
                if (indic[n][s] == 1.0) {
                    int[] nArray = this.count_m[s];
                    int n3 = c_current;
                    nArray[n3] = nArray[n3] + 1;
                    int[] nArray2 = this.count_m_all[s];
                    int n4 = c_current;
                    nArray2[n4] = nArray2[n4] + 1;
                    continue;
                }
                if (indic[n][s] != 0.0) continue;
                int[] nArray = this.count_m_all[s];
                int n5 = c_current;
                nArray[n5] = nArray[n5] + 1;
            }
        }
    }

    public double[][] pnb(boolean contains_missing, double[][] indic, double[][] csmf_sub, int[] subpop, int[][] zero_matrix) {
        int n;
        double[][] nb = new double[this.N][this.C];
        for (n = 0; n < this.N; ++n) {
            for (int c = 0; c < this.C; ++c) {
                nb[n][c] = csmf_sub[subpop[n]][c] * (double)zero_matrix[n][c];
            }
        }
        for (n = 0; n < this.N; ++n) {
            ArrayList<Integer> nomissing = new ArrayList<Integer>();
            for (int s = 0; s < indic[n].length; ++s) {
                if (!(indic[n][s] >= 0.0)) continue;
                nomissing.add(s);
            }
            for (int c = 0; c < this.C; ++c) {
                Iterator iterator = nomissing.iterator();
                while (iterator.hasNext()) {
                    int s = (Integer)iterator.next();
                    double[] dArray = nb[n];
                    int n2 = c;
                    dArray[n2] = dArray[n2] * (indic[n][s] > 0.0 ? this.probbase[s][c] : 1.0 - this.probbase[s][c]);
                }
            }
            nb[n] = MathUtil.norm(nb[n]);
        }
        return nb;
    }

    public double[][] pnb(boolean contains_missing, double[][] indic, double[][] csmf_sub, int[] subpop, int[] g_new, int[][] zero_matrix) {
        int n;
        double[][] nb = new double[this.N][this.C];
        for (n = 0; n < this.N; ++n) {
            for (int c : this.catmap.get(g_new[n])) {
                nb[n][c] = csmf_sub[subpop[n]][c] * (double)zero_matrix[n][c];
            }
        }
        for (n = 0; n < this.N; ++n) {
            ArrayList<Integer> nomissing = new ArrayList<Integer>();
            for (int s = 0; s < indic[n].length; ++s) {
                if (!(indic[n][s] >= 0.0)) continue;
                nomissing.add(s);
            }
            for (int c : this.catmap.get(g_new[n])) {
                Iterator iterator = nomissing.iterator();
                while (iterator.hasNext()) {
                    int s = (Integer)iterator.next();
                    double[] dArray = nb[n];
                    int n2 = c;
                    dArray[n2] = dArray[n2] * (indic[n][s] > 0.0 ? this.probbase[s][c] : 1.0 - this.probbase[s][c]);
                }
            }
            nb[n] = MathUtil.norm(nb[n]);
        }
        return nb;
    }

    public int[] sampleY(double[][] pnb, Random rand) {
        int[] y = new int[pnb.length];
        block0: for (int n = 0; n < pnb.length; ++n) {
            double u = rand.nextDouble();
            double cum = 0.0;
            for (int c = 0; c < pnb[n].length; ++c) {
                if (!(u < (cum += pnb[n][c]))) continue;
                y[n] = c;
                continue block0;
            }
        }
        return y;
    }

    public double[] thetaBlockUpdate(double jumprange, double[] mu, double sigma2, double[] theta, int[] Y, boolean jump_prop, Normal rngN, Random rand, int[] zero_vector) {
        double[] jump = new double[this.C];
        for (int c = 0; c < this.C; ++c) {
            jump[c] = jumprange;
        }
        if (jump_prop) {
            // empty if block
        }
        double[] theta_new = new double[this.C];
        int fix = 0;
        for (int i = 0; i < zero_vector.length; ++i) {
            if (zero_vector[i] == 0) continue;
            fix = i;
            break;
        }
        theta_new[fix] = 1.0;
        double expsum = Math.exp(1.0);
        double expsum_new = Math.exp(1.0);
        for (int c = fix + 1; c < this.C; ++c) {
            theta_new[c] = rngN.nextDouble(theta[c], jump[c]) * (double)zero_vector[c];
            expsum += Math.exp(theta[c]);
            expsum_new += Math.exp(theta_new[c]);
        }
        double logTrans = 0.0;
        for (int c = 0; c < this.C; ++c) {
            if (zero_vector[c] <= 0) continue;
            double diffquad = (theta_new[c] - mu[c]) * (theta_new[c] - mu[c]) - (theta[c] - mu[c]) * (theta[c] - mu[c]);
            logTrans += (double)Y[c] * (theta_new[c] - theta[c] - Math.log(expsum_new / expsum)) - 1.0 / (2.0 * sigma2) * diffquad;
        }
        double u = Math.log(rand.nextDouble());
        if (!(logTrans >= u)) {
            return theta;
        }
        return theta_new;
    }

    public void TruncBeta2(Random rand, double[] prior_a, double prior_b, double trunc_min, double trunc_max) {
        int s;
        double a = 0.0;
        double b = 0.0;
        double[][] new_probbase = new double[this.C][this.S];
        for (s = 0; s < this.S; ++s) {
            for (int c = 0; c < this.C; ++c) {
                new_probbase[c][s] = this.probbase[s][c];
            }
        }
        for (s = 0; s < this.S; ++s) {
            HashMap<Integer, ArrayList<Integer>> levels_under_s = this.probbase_level.get(s);
            double[] prob_under_s = this.probbase[s];
            double[] new_prob_under_s = new double[this.C];
            ArrayList<Integer> exist_levels_under_s = new ArrayList<Integer>();
            for (int l = 1; l <= this.N_level; ++l) {
                if (levels_under_s.get(l) == null) continue;
                exist_levels_under_s.add(l);
            }
            for (int index = 0; index < exist_levels_under_s.size(); ++index) {
                int l_current = (Integer)exist_levels_under_s.get(index);
                for (int c : levels_under_s.get(l_current)) {
                    int l_next;
                    int count = this.count_m[s][c];
                    int count_all = this.count_m_all[s][c];
                    double lower = 0.0;
                    double upper = 1.0;
                    if (index == 0) {
                        l_next = (Integer)exist_levels_under_s.get(index + 1);
                        lower = MathUtil.array_max(prob_under_s, levels_under_s.get(l_next));
                        lower = Math.max(lower, trunc_min);
                        upper = trunc_max;
                    } else if (index == exist_levels_under_s.size() - 1) {
                        lower = trunc_min;
                        int l_prev = (Integer)exist_levels_under_s.get(index - 1);
                        upper = MathUtil.array_min(new_prob_under_s, levels_under_s.get(l_prev));
                        upper = Math.min(upper, trunc_max);
                    } else {
                        l_next = (Integer)exist_levels_under_s.get(index + 1);
                        lower = MathUtil.array_max(prob_under_s, levels_under_s.get(l_next));
                        lower = Math.max(lower, trunc_min);
                        int l_prev = (Integer)exist_levels_under_s.get(index - 1);
                        upper = MathUtil.array_min(new_prob_under_s, levels_under_s.get(l_prev));
                        upper = Math.min(upper, trunc_max);
                    }
                    if (lower >= upper) {
                        new_prob_under_s[c] = upper;
                        continue;
                    }
                    a = prior_a[l_current - 1] + (double)count;
                    b = prior_b + (double)count_all - a;
                    BetaDistribution beta = new BetaDistribution(a, b, 1.0E-10);
                    new_prob_under_s[c] = MathUtil.truncbeta(beta, rand, lower, upper);
                }
            }
            for (int c = 0; c < this.C; ++c) {
                this.probbase[s][c] = new_prob_under_s[c];
            }
        }
    }

    public void TruncBeta(Random rand, double[] prior_a, double prior_b, double trunc_min, double trunc_max) {
        double a = 0.0;
        double b = 0.0;
        double[][] new_probbase = new double[this.S][this.C];
        for (int s = 0; s < this.S; ++s) {
            for (int c = 0; c < this.C; ++c) {
                new_probbase[s][c] = this.probbase[s][c];
            }
        }
        for (int c = 0; c < this.C; ++c) {
            HashMap<Integer, ArrayList<Integer>> levels_under_c = this.probbase_level.get(c);
            double[] prob_under_c = MathUtil.grab2(this.probbase, c);
            double[] new_prob_under_c = new double[this.S];
            ArrayList<Integer> exist_levels_under_c = new ArrayList<Integer>();
            for (int l = 1; l <= this.N_level; ++l) {
                if (levels_under_c.get(l) == null) continue;
                exist_levels_under_c.add(l);
            }
            for (int index = 0; index < exist_levels_under_c.size(); ++index) {
                int l_current = (Integer)exist_levels_under_c.get(index);
                for (int s : levels_under_c.get(l_current)) {
                    int l_next;
                    int count = this.count_m[s][c];
                    int count_all = this.count_m_all[s][c];
                    double lower = 0.0;
                    double upper = 1.0;
                    if (index == 0) {
                        l_next = (Integer)exist_levels_under_c.get(index + 1);
                        lower = MathUtil.array_max(prob_under_c, levels_under_c.get(l_next));
                        lower = Math.max(lower, trunc_min);
                        upper = trunc_max;
                    } else if (index == exist_levels_under_c.size() - 1) {
                        lower = trunc_min;
                        int l_prev = (Integer)exist_levels_under_c.get(index - 1);
                        upper = MathUtil.array_min(new_prob_under_c, levels_under_c.get(l_prev));
                        upper = Math.min(upper, trunc_max);
                    } else {
                        l_next = (Integer)exist_levels_under_c.get(index + 1);
                        lower = MathUtil.array_max(prob_under_c, levels_under_c.get(l_next));
                        lower = Math.max(lower, trunc_min);
                        int l_prev = (Integer)exist_levels_under_c.get(index - 1);
                        upper = MathUtil.array_min(new_prob_under_c, levels_under_c.get(l_prev));
                        upper = Math.min(upper, trunc_max);
                    }
                    if (lower >= upper) {
                        new_prob_under_c[s] = upper;
                        continue;
                    }
                    a = prior_a[l_current - 1] + (double)count;
                    b = prior_b + (double)count_all - a;
                    BetaDistribution beta = new BetaDistribution(a, b, 1.0E-10);
                    new_prob_under_c[s] = MathUtil.truncbeta(beta, rand, lower, upper);
                }
            }
            for (int s = 0; s < this.S; ++s) {
                this.probbase[s][c] = new_prob_under_c[s];
            }
        }
    }

    public void TruncBeta_pool(Random rand, double[] prior_a, double prior_b, double trunc_min, double trunc_max) {
        double a = 0.0;
        double b = 0.0;
        double[][] new_probbase = new double[this.S][this.C];
        for (int s = 0; s < this.S; ++s) {
            for (int c = 0; c < this.C; ++c) {
                new_probbase[s][c] = this.probbase[s][c];
            }
        }
        double[] new_level_values = new double[this.N_level];
        for (int l = 1; l <= this.N_level; ++l) {
            int count = 0;
            int count_all = 0;
            for (int c = 0; c < this.C; ++c) {
                if (this.probbase_level.get(c).get(l) == null) continue;
                for (int s : this.probbase_level.get(c).get(l)) {
                    count += this.count_m[s][c];
                    count_all += this.count_m_all[s][c];
                }
            }
            double lower = 0.0;
            double upper = 1.0;
            if (l == 1) {
                lower = Math.max(this.level_values[l], trunc_min);
                upper = trunc_max;
            } else if (l == this.N_level) {
                lower = trunc_min;
                upper = Math.min(new_level_values[l - 2], trunc_max);
            } else {
                lower = Math.max(this.level_values[l], trunc_min);
                upper = Math.min(new_level_values[l - 2], trunc_max);
            }
            if (lower >= upper) {
                new_level_values[l - 1] = upper;
                continue;
            }
            a = prior_a[l - 1] + (double)count;
            b = prior_b + (double)count_all - a;
            BetaDistribution beta = new BetaDistribution(a, b, 1.0E-10);
            new_level_values[l - 1] = MathUtil.truncbeta(beta, rand, lower, upper);
        }
        this.level_values = new_level_values;
        for (int s = 0; s < this.S; ++s) {
            for (int c = 0; c < this.C; ++c) {
                this.probbase[s][c] = this.level_values[(int)this.probbase_order[s][c] - 1];
            }
        }
    }

    public static double[] Fit(int[] dimensions, double[][] probbase, double[][] probbase_order, double[] level_values, double[] prior_a, double prior_b, double jumprange, double trunc_min, double trunc_max, double[][] indic, int[] subpop, int contains_missing, int pool, int seed, int N_gibbs, int burn, int thin, double[] mu, double sigma2, boolean this_is_Unix, boolean useProbbase, boolean isAdded, double[][] mu_continue, double[] sigma2_continue, double[][] theta_continue, int C_phy, double[] broader, double[][] assignment, int[][] impossible) {
        int sub;
        double[][] pnb;
        int i;
        int c;
        double expsum;
        int sub2;
        boolean withPhy;
        int N = dimensions[0];
        int S = dimensions[1];
        int C = dimensions[2];
        int N_sub = dimensions[3];
        int N_level = dimensions[4];
        InsilicoSampler2 insilico = new InsilicoSampler2();
        boolean bl = withPhy = C_phy > 1;
        if (!withPhy) {
            insilico.initiate(N, S, C, N_sub, N_level, subpop, probbase, probbase_order, level_values, pool);
        } else {
            insilico.initiate(N, S, C, N_sub, N_level, subpop, probbase, probbase_order, level_values, pool, C_phy, broader);
        }
        System.out.printf("InSilicoVA Sampler Initiated, %d Iterations to Sample\n", N_gibbs);
        DoubleMersenneTwister rngEngine = new DoubleMersenneTwister(seed);
        Normal rngN = new Normal(0.0, 1.0, rngEngine);
        Gamma rngG = new Gamma(1.0, 1.0, rngEngine);
        Random rand = new Random(seed);
        int N_thin = (int)((double)(N_gibbs - burn) / ((double)thin + 0.0));
        int n_report = Math.max(N_gibbs / 20, 100);
        if (N_gibbs < 200) {
            n_report = 50;
        }
        double[][][] probbase_gibbs = new double[N_thin][S][C];
        double[][] levels_gibbs = new double[N_thin][N_level];
        double[][][] p_gibbs = new double[N_thin][N_sub][C];
        double[][] pnb_mean = new double[N][C];
        int[] naccept = new int[N_sub];
        double[][] mu_now = new double[N_sub][C];
        double[] sigma2_now = new double[N_sub];
        double[][] theta_now = new double[N_sub][C];
        double[][] p_now = new double[N_sub][C];
        if (!isAdded) {
            for (sub2 = 0; sub2 < N_sub; ++sub2) {
                mu_now[sub2] = mu;
                sigma2_now[sub2] = sigma2;
                theta_now[sub2][0] = 1.0;
                expsum = Math.exp(1.0);
                for (c = 1; c < C; ++c) {
                    theta_now[sub2][c] = Math.log(rand.nextDouble() * 100.0);
                    expsum += Math.exp(theta_now[sub2][c]);
                }
                for (c = 0; c < C; ++c) {
                    p_now[sub2][c] = Math.exp(theta_now[sub2][c]) / expsum;
                }
            }
        } else {
            for (sub2 = 0; sub2 < N_sub; ++sub2) {
                mu_now[sub2] = mu_continue[sub2];
                sigma2_now[sub2] = sigma2_continue[sub2];
                theta_now[sub2] = theta_continue[sub2];
                expsum = Math.exp(1.0);
                for (c = 1; c < C; ++c) {
                    expsum += Math.exp(theta_now[sub2][c]);
                }
                for (c = 0; c < C; ++c) {
                    p_now[sub2][c] = Math.exp(theta_now[sub2][c]) / expsum;
                }
            }
        }
        boolean check_impossible = impossible[0].length == 3;
        int[][] zero_matrix = new int[N][C];
        for (i = 0; i < N; ++i) {
            for (int j = 0; j < C; ++j) {
                zero_matrix[i][j] = 1;
            }
        }
        if (check_impossible) {
            for (i = 0; i < N; ++i) {
                for (int k = 0; k < impossible.length; ++k) {
                    if (indic[i][impossible[k][1] - 1] == 1.0 & impossible[k][2] == 0) {
                        zero_matrix[i][impossible[k][0] - 1] = 0;
                    }
                    if (!(indic[i][impossible[k][1] - 1] == 0.0 & impossible[k][2] == 1)) continue;
                    zero_matrix[i][impossible[k][0] - 1] = 0;
                }
            }
        }
        int[][] zero_group_matrix = new int[N_sub][C];
        int[] remove_causes = new int[N_sub];
        if (check_impossible) {
            int i2;
            int j;
            for (j = 0; j < C; ++j) {
                for (i2 = 0; i2 < N; ++i2) {
                    int[] nArray = zero_group_matrix[subpop[i2]];
                    int n = j;
                    nArray[n] = nArray[n] + zero_matrix[i2][j];
                }
            }
            for (j = 0; j < C; ++j) {
                for (i2 = 0; i2 < N_sub; ++i2) {
                    zero_group_matrix[i2][j] = zero_group_matrix[i2][j] == 0 ? 0 : 1;
                    int n = i2;
                    remove_causes[n] = remove_causes[n] + (1 - zero_group_matrix[i2][j]);
                }
            }
        } else {
            for (int i3 = 0; i3 < N_sub; ++i3) {
                for (int j = 0; j < C; ++j) {
                    zero_group_matrix[i3][j] = 1;
                }
            }
        }
        if (!isAdded) {
            for (int sub3 = 0; sub3 < N_sub; ++sub3) {
                int c2;
                int fix = 0;
                for (int c3 = 1; c3 < C; ++c3) {
                    if (zero_group_matrix[sub3][c3] <= 0) continue;
                    fix = c3;
                    break;
                }
                theta_now[sub3][fix] = 1.0;
                double expsum2 = Math.exp(1.0);
                for (c2 = fix + 1; c2 < C; ++c2) {
                    theta_now[sub3][c2] = Math.log(rand.nextDouble() * 100.0);
                    expsum2 += Math.exp(theta_now[sub3][c2]) * (double)zero_group_matrix[sub3][c2];
                }
                for (c2 = 0; c2 < C; ++c2) {
                    p_now[sub3][c2] = Math.exp(theta_now[sub3][c2]) * (double)zero_group_matrix[sub3][c2] / expsum2;
                }
            }
        }
        if (!withPhy) {
            pnb = insilico.pnb(contains_missing == 1, indic, p_now, subpop, zero_matrix);
        } else {
            int[] g_new = insilico.sampleY(assignment, rand);
            pnb = insilico.pnb(contains_missing == 1, indic, p_now, subpop, g_new, zero_matrix);
        }
        long start = System.currentTimeMillis();
        ProgressPopup popup = new ProgressPopup(this_is_Unix, N_gibbs);
        for (int k = 0; k < N_gibbs; ++k) {
            int d1;
            if (!this_is_Unix) {
                popup.update(k);
            }
            int[] y_new = insilico.sampleY(pnb, rand);
            int[] g_new = insilico.sampleY(assignment, rand);
            int[][] Y = new int[N_sub][C];
            for (int n = 0; n < N; ++n) {
                int[] nArray = Y[subpop[n]];
                int n2 = y_new[n];
                nArray[n2] = nArray[n2] + 1;
            }
            for (int sub4 = 0; sub4 < N_sub; ++sub4) {
                int c4;
                int c5;
                double mu_mean = 0.0;
                for (c5 = 0; c5 < C; ++c5) {
                    mu_mean += theta_now[sub4][c5];
                }
                mu_mean /= (double)(C - remove_causes[sub4]) + 0.0;
                mu_mean = rngN.nextDouble(mu_mean, Math.sqrt(sigma2_now[sub4] / ((double)(C - remove_causes[sub4]) + 0.0)));
                for (c5 = 0; c5 < C; ++c5) {
                    mu_now[sub4][c5] = mu_mean;
                }
                double shape = ((double)(C - remove_causes[sub4]) - 1.0) / 2.0;
                double rate2 = 0.0;
                for (int c6 = 0; c6 < C; ++c6) {
                    rate2 += Math.pow(theta_now[sub4][c6] - mu_now[sub4][c6] * (double)zero_group_matrix[sub4][c6], 2.0);
                }
                sigma2_now[sub4] = 1.0 / rngG.nextDouble(shape, rate2 / 2.0);
                double[] theta_prev = theta_now[sub4];
                theta_now[sub4] = insilico.thetaBlockUpdate(jumprange, mu_now[sub4], sigma2_now[sub4], theta_prev, Y[sub4], false, rngN, rand, zero_group_matrix[sub4]);
                for (int j = 0; j < theta_prev.length; ++j) {
                    if (theta_now[sub4][j] == theta_prev[j]) continue;
                    int n = sub4;
                    naccept[n] = naccept[n] + 1;
                    break;
                }
                double expsum3 = 0.0;
                for (c4 = 0; c4 < C; ++c4) {
                    expsum3 += Math.exp(theta_now[sub4][c4]) * (double)zero_group_matrix[sub4][c4];
                }
                for (c4 = 0; c4 < C; ++c4) {
                    p_now[sub4][c4] = Math.exp(theta_now[sub4][c4]) * (double)zero_group_matrix[sub4][c4] / expsum3;
                }
            }
            if (!useProbbase) {
                insilico.CountCurrent(indic, y_new);
                if (pool == 0) {
                    insilico.TruncBeta_pool(rand, prior_a, prior_b, trunc_min, trunc_max);
                } else if (pool == 1) {
                    insilico.TruncBeta(rand, prior_a, prior_b, trunc_min, trunc_max);
                } else if (pool == 2) {
                    insilico.TruncBeta2(rand, prior_a, prior_b, trunc_min, trunc_max);
                }
            }
            pnb = !withPhy ? insilico.pnb(contains_missing == 1, indic, p_now, subpop, zero_matrix) : insilico.pnb(contains_missing == 1, indic, p_now, subpop, g_new, zero_matrix);
            if (k % 10 == 0) {
                System.out.printf(".", new Object[0]);
            }
            if (k % n_report == 0 & k != 0) {
                long now = System.currentTimeMillis();
                String message = String.format("\nIteration: %d \n", k);
                for (int sub5 = 0; sub5 < N_sub; ++sub5) {
                    double ratio = (double)naccept[sub5] / ((double)k + 0.0);
                    message = message + String.format("Sub-population %d acceptance ratio: %.2f \n", sub5, ratio);
                }
                System.out.printf(message, new Object[0]);
                System.out.printf("%.2fmin elapsed, %.2fmin remaining \n", (double)(now - start) / 1000.0 / 60.0, (double)(now - start) / 1000.0 / 60.0 / ((double)k + 0.0) * (double)(N_gibbs - k));
                if (!this_is_Unix) {
                    popup.message(k, message);
                }
            }
            if (k < burn || (k - burn + 1) % thin != 0) continue;
            int save = (k - burn + 1) / thin - 1;
            for (d1 = 0; d1 < N; ++d1) {
                for (int d2 = 0; d2 < C; ++d2) {
                    double[] dArray = pnb_mean[d1];
                    int n = d2;
                    dArray[n] = dArray[n] + pnb[d1][d2];
                }
            }
            for (d1 = 0; d1 < N_sub; ++d1) {
                for (int d2 = 0; d2 < C; ++d2) {
                    p_gibbs[save][d1][d2] = p_now[d1][d2];
                }
            }
            if (pool == 0) {
                for (d1 = 0; d1 < N_level; ++d1) {
                    levels_gibbs[save][d1] = insilico.level_values[d1];
                }
                continue;
            }
            for (d1 = 0; d1 < S; ++d1) {
                for (int d2 = 0; d2 < C; ++d2) {
                    probbase_gibbs[save][d1][d2] = insilico.probbase[d1][d2];
                }
            }
        }
        if (!this_is_Unix) {
            popup.close();
        }
        System.out.println("\nOverall acceptance ratio");
        for (int sub6 = 0; sub6 < N_sub; ++sub6) {
            double ratio = (double)naccept[sub6] / ((double)N_gibbs + 0.0);
            System.out.printf("Sub-population %d : %.4f \n", sub6, ratio);
        }
        int N_out = 1 + N_sub * C * N_thin + N * C + N_sub * (C * 2 + 1);
        N_out = pool == 0 ? (N_out += N_level * N_thin) : (N_out += S * C * N_thin);
        double[] parameters = new double[N_out];
        int counter = 0;
        parameters[0] = N_thin;
        counter = 1;
        for (sub = 0; sub < N_sub; ++sub) {
            for (int k = 0; k < N_thin; ++k) {
                for (int c7 = 0; c7 < C; ++c7) {
                    parameters[counter] = p_gibbs[k][sub][c7];
                    ++counter;
                }
            }
        }
        for (int n = 0; n < N; ++n) {
            for (int c8 = 0; c8 < C; ++c8) {
                parameters[counter] = pnb_mean[n][c8] / ((double)N_thin + 0.0);
                ++counter;
            }
        }
        if (pool != 0) {
            for (int c9 = 0; c9 < C; ++c9) {
                for (int s = 0; s < S; ++s) {
                    for (int k = 0; k < N_thin; ++k) {
                        parameters[counter] = probbase_gibbs[k][s][c9];
                        ++counter;
                    }
                }
            }
        } else {
            for (int k = 0; k < N_thin; ++k) {
                for (int l = 1; l <= N_level; ++l) {
                    parameters[counter] = levels_gibbs[k][l - 1];
                    ++counter;
                }
            }
        }
        for (sub = 0; sub < N_sub; ++sub) {
            for (int c10 = 0; c10 < C; ++c10) {
                parameters[counter] = mu_now[sub][c10];
                ++counter;
            }
        }
        for (sub = 0; sub < N_sub; ++sub) {
            parameters[counter] = sigma2_now[sub];
            ++counter;
        }
        for (sub = 0; sub < N_sub; ++sub) {
            for (int c11 = 0; c11 < C; ++c11) {
                parameters[counter] = theta_now[sub][c11];
                ++counter;
            }
        }
        System.out.println("Organizing output, might take a moment...");
        return parameters;
    }

    public static double[][] Datacheck(int[][] DontAsk, int[][] AskIf, int[] zero_to_missing_list, double[][] data, String[] ids, String[] symps, String warningfile) throws FileNotFoundException, UnsupportedEncodingException {
        boolean write = ids.length > 1;
        boolean[] set_to_missing = new boolean[data[0].length];
        if (zero_to_missing_list[0] != 0) {
            for (int i : zero_to_missing_list) {
                set_to_missing[i - 1] = true;
            }
        }
        PrintWriter writer = new PrintWriter(warningfile, "UTF-8");
        if (write) {
            writer.println("Warning log built for InSilicoVA");
        }
        for (int i = 0; i < data.length; ++i) {
            for (int k = 0; k < 2; ++k) {
                block3: for (int j = 0; j < data[i].length; ++j) {
                    boolean is_this_missing;
                    int t;
                    if (data[i][j] != -1.0) {
                        for (t = 0; t < DontAsk[j].length; ++t) {
                            if (DontAsk[j][t] == 0 || data[i][DontAsk[j][t] - 1] != 1.0) continue;
                            is_this_missing = set_to_missing[DontAsk[j][t] - 1];
                            double d = data[i][j] = is_this_missing ? -1.0 : 0.0;
                            if (write) {
                                writer.println(ids[i] + " " + symps[j] + " value inconsistent with " + symps[DontAsk[j][t]] + " - cleared or set to missing in working file");
                            }
                            if (is_this_missing) break;
                        }
                        for (t = 0; t < AskIf[j].length; ++t) {
                            if (AskIf[j][t] == 0 | data[i][j] != 1.0) continue;
                            data[i][AskIf[j][t] - 1] = 1.0;
                            if (!write) continue;
                            writer.println(ids[i] + " " + symps[j] + " not flagged in category " + symps[DontAsk[j][t]] + " - updated in working file");
                        }
                        continue;
                    }
                    if (data[i][j] != -1.0) continue;
                    for (t = 0; t < DontAsk[j].length; ++t) {
                        if (DontAsk[j][t] == 0 || data[i][DontAsk[j][t] - 1] != 1.0) continue;
                        is_this_missing = set_to_missing[DontAsk[j][t] - 1];
                        double d = data[i][j] = is_this_missing ? -1.0 : 0.0;
                        if (write) {
                            writer.println(ids[i] + " " + symps[j] + " value inconsistent with " + symps[DontAsk[j][t]] + " - set to No or Missing in working file");
                        }
                        if (is_this_missing) continue block3;
                    }
                }
            }
        }
        writer.close();
        return data;
    }

    public static double[][] Datacheck(int[][] DontAsk, int[][] AskIf, int[] zero_to_missing_list, double[][] data) throws FileNotFoundException, UnsupportedEncodingException {
        String[] ids = new String[]{};
        String[] symps = new String[]{};
        String warningfile = "warnings.txt";
        return InsilicoSampler2.Datacheck(DontAsk, AskIf, zero_to_missing_list, data, ids, symps, warningfile);
    }

    public static double[][] IndivProb(double[][] data, int[][] impossible, double[] csmf0, int[] subpop, double[] condprob0, double p0, double p1, int Nsub, int Nitr, int C, int S) {
        int i;
        int k;
        int j;
        int i2;
        int N = data.length;
        double[][][] csmf = new double[Nsub][Nitr][C];
        double[][][] condprob = new double[Nitr][S][C];
        for (i2 = 0; i2 < Nsub; ++i2) {
            for (j = 0; j < Nitr; ++j) {
                for (k = 0; k < C; ++k) {
                    csmf[i2][j][k] = csmf0[k * Nsub * Nitr + j * Nsub + i2];
                }
            }
        }
        for (i2 = 0; i2 < Nitr; ++i2) {
            for (j = 0; j < S; ++j) {
                for (k = 0; k < C; ++k) {
                    condprob[i2][j][k] = condprob0[k * Nitr * S + j * Nitr + i2];
                }
            }
        }
        int[][] zero_matrix = new int[N][C];
        for (i = 0; i < N; ++i) {
            for (int j2 = 0; j2 < C; ++j2) {
                zero_matrix[i][j2] = 1;
            }
        }
        if (impossible[0].length == 2) {
            for (i = 0; i < N; ++i) {
                for (k = 0; k < impossible.length; ++k) {
                    if (data[i][impossible[k][1] - 1] != 1.0) continue;
                    zero_matrix[i][impossible[k][0] - 1] = 0;
                }
            }
        }
        double[][][] allp = new double[N][C][Nitr];
        for (int i3 = 0; i3 < N; ++i3) {
            int sub = subpop[i3] - 1;
            for (int t = 0; t < Nitr; ++t) {
                int c;
                double sum = 0.0;
                for (c = 0; c < C; ++c) {
                    allp[i3][c][t] = csmf[sub][t][c] * (double)zero_matrix[i3][c];
                    for (int s = 0; s < S; ++s) {
                        if (condprob[t][s][c] == 0.0) {
                            System.out.print(".");
                        }
                        if (data[i3][s] == 1.0) {
                            double[] dArray = allp[i3][c];
                            int n = t;
                            dArray[n] = dArray[n] * condprob[t][s][c];
                            continue;
                        }
                        if (data[i3][s] != 0.0) continue;
                        double[] dArray = allp[i3][c];
                        int n = t;
                        dArray[n] = dArray[n] * (1.0 - condprob[t][s][c]);
                    }
                    sum += allp[i3][c][t];
                }
                for (c = 0; c < C; ++c) {
                    allp[i3][c][t] = sum == 0.0 ? allp[i3][c][t] : allp[i3][c][t] / sum;
                }
            }
        }
        double[][] out = new double[N * 4][C];
        for (int i4 = 0; i4 < N; ++i4) {
            for (int c = 0; c < C; ++c) {
                out[i4][c] = MathUtil.getMean(allp[i4][c]);
                out[i4 + N][c] = MathUtil.getPercentile(allp[i4][c], 0.5);
                out[i4 + N * 2][c] = MathUtil.getPercentile(allp[i4][c], p0);
                out[i4 + N * 3][c] = MathUtil.getPercentile(allp[i4][c], p1);
            }
        }
        return out;
    }

    public static double[][] AggIndivProb(double[][] data, int[][] impossible, double[] csmf0, int[] subpop, double[] condprob0, int[] group, int Ngroup, double p0, double p1, int Nsub, int Nitr, int C, int S) {
        int i;
        int k;
        int j;
        int i2;
        int N = data.length;
        double[][][] csmf = new double[Nsub][Nitr][C];
        double[][][] condprob = new double[Nitr][S][C];
        for (i2 = 0; i2 < Nsub; ++i2) {
            for (j = 0; j < Nitr; ++j) {
                for (k = 0; k < C; ++k) {
                    csmf[i2][j][k] = csmf0[k * Nsub * Nitr + j * Nsub + i2];
                }
            }
        }
        for (i2 = 0; i2 < Nitr; ++i2) {
            for (j = 0; j < S; ++j) {
                for (k = 0; k < C; ++k) {
                    condprob[i2][j][k] = condprob0[k * Nitr * S + j * Nitr + i2];
                }
            }
        }
        int[][] zero_matrix = new int[N][C];
        for (i = 0; i < N; ++i) {
            for (int j2 = 0; j2 < C; ++j2) {
                zero_matrix[i][j2] = 1;
            }
        }
        if (impossible[0].length == 2) {
            for (i = 0; i < N; ++i) {
                for (k = 0; k < impossible.length; ++k) {
                    if (data[i][impossible[k][1] - 1] != 1.0) continue;
                    zero_matrix[i][impossible[k][0] - 1] = 0;
                }
            }
        }
        double[][][] allp = new double[Ngroup][C][Nitr];
        int[] size = new int[Ngroup];
        for (int i3 = 0; i3 < N; ++i3) {
            int g;
            int sub = subpop[i3] - 1;
            int n = g = group[i3] - 1;
            size[n] = size[n] + 1;
            for (int t = 0; t < Nitr; ++t) {
                int c;
                double[] tmp = new double[C];
                double sum = 0.0;
                for (c = 0; c < C; ++c) {
                    tmp[c] = csmf[sub][t][c] * (double)zero_matrix[i3][c];
                    for (int s = 0; s < S; ++s) {
                        if (data[i3][s] == 1.0) {
                            int n2 = c;
                            tmp[n2] = tmp[n2] * condprob[t][s][c];
                            continue;
                        }
                        if (data[i3][s] != 0.0) continue;
                        int n3 = c;
                        tmp[n3] = tmp[n3] * (1.0 - condprob[t][s][c]);
                    }
                    sum += tmp[c];
                }
                for (c = 0; c < C; ++c) {
                    double[] dArray = allp[g][c];
                    int n4 = t;
                    dArray[n4] = dArray[n4] + (sum == 0.0 ? tmp[c] : tmp[c] / sum);
                }
            }
        }
        double[][] out = new double[Ngroup * 4][C + 1];
        for (int i4 = 0; i4 < Ngroup; ++i4) {
            for (int c = 0; c < C; ++c) {
                out[i4][c] = MathUtil.getMean(allp[i4][c]) / ((double)size[i4] + 0.0);
                out[i4 + Ngroup][c] = MathUtil.getPercentile(allp[i4][c], 0.5) / ((double)size[i4] + 0.0);
                out[i4 + Ngroup * 2][c] = MathUtil.getPercentile(allp[i4][c], p0) / ((double)size[i4] + 0.0);
                out[i4 + Ngroup * 3][c] = MathUtil.getPercentile(allp[i4][c], p1) / ((double)size[i4] + 0.0);
            }
            out[i4][C] = size[i4];
            out[i4 + Ngroup][C] = size[i4];
            out[i4 + Ngroup * 2][C] = size[i4];
            out[i4 + Ngroup * 3][C] = size[i4];
        }
        return out;
    }
}

