/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.matrix.tdcomplex.DComplexMatrix3D;
import cern.colt.matrix.tdcomplex.impl.DenseLargeDComplexMatrix3D;
import cern.colt.matrix.tdouble.DoubleMatrix3D;
import cern.colt.matrix.tdouble.DoubleMatrix3DTest;
import cern.colt.matrix.tdouble.impl.DenseLargeDoubleMatrix3D;
import cern.colt.matrix.tdouble.impl.WrapperDoubleMatrix3D;

public class DenseLargeDoubleMatrix3DTest
extends DoubleMatrix3DTest {
    public DenseLargeDoubleMatrix3DTest(String string) {
        super(string);
    }

    protected void createMatrices() throws Exception {
        this.A = new DenseLargeDoubleMatrix3D(this.NSLICES, this.NROWS, this.NCOLUMNS);
        this.B = new DenseLargeDoubleMatrix3D(this.NSLICES, this.NROWS, this.NCOLUMNS);
    }

    public void testDct3() {
        DoubleMatrix3D doubleMatrix3D = this.A.copy();
        ((WrapperDoubleMatrix3D)this.A).dct3(true);
        ((WrapperDoubleMatrix3D)this.A).idct3(true);
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    DenseLargeDoubleMatrix3DTest.assertEquals((double)doubleMatrix3D.getQuick(i, j, k), (double)this.A.getQuick(i, j, k), (double)this.TOL);
                }
            }
        }
    }

    public void testDst3() {
        DoubleMatrix3D doubleMatrix3D = this.A.copy();
        ((WrapperDoubleMatrix3D)this.A).dst3(true);
        ((WrapperDoubleMatrix3D)this.A).idst3(true);
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    DenseLargeDoubleMatrix3DTest.assertEquals((double)doubleMatrix3D.getQuick(i, j, k), (double)this.A.getQuick(i, j, k), (double)this.TOL);
                }
            }
        }
    }

    public void testDht3() {
        DoubleMatrix3D doubleMatrix3D = this.A.copy();
        ((WrapperDoubleMatrix3D)this.A).dht3();
        ((WrapperDoubleMatrix3D)this.A).idht3(true);
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    DenseLargeDoubleMatrix3DTest.assertEquals((double)doubleMatrix3D.getQuick(i, j, k), (double)this.A.getQuick(i, j, k), (double)this.TOL);
                }
            }
        }
    }

    public void testFft3() {
        int n;
        int n2;
        int n3;
        int n4 = 16;
        int n5 = 32;
        int n6 = 64;
        DoubleMatrix3D doubleMatrix3D = new DenseLargeDoubleMatrix3D(n4, n5, n6);
        DoubleMatrix3D doubleMatrix3D2 = doubleMatrix3D.copy();
        ((WrapperDoubleMatrix3D)doubleMatrix3D).fft3();
        ((WrapperDoubleMatrix3D)doubleMatrix3D).ifft3(true);
        for (n3 = 0; n3 < n4; ++n3) {
            for (n2 = 0; n2 < n5; ++n2) {
                for (n = 0; n < n6; ++n) {
                    DenseLargeDoubleMatrix3DTest.assertEquals((double)doubleMatrix3D2.getQuick(n3, n2, n), (double)doubleMatrix3D.getQuick(n3, n2, n), (double)this.TOL);
                }
            }
        }
        doubleMatrix3D = doubleMatrix3D.viewDice(2, 1, 0);
        doubleMatrix3D2 = doubleMatrix3D.copy();
        ((WrapperDoubleMatrix3D)doubleMatrix3D).fft3();
        ((WrapperDoubleMatrix3D)doubleMatrix3D).ifft3(true);
        for (n3 = 0; n3 < n6; ++n3) {
            for (n2 = 0; n2 < n5; ++n2) {
                for (n = 0; n < n4; ++n) {
                    DenseLargeDoubleMatrix3DTest.assertEquals((double)0.0, (double)Math.abs(doubleMatrix3D2.getQuick(n3, n2, n) - doubleMatrix3D.getQuick(n3, n2, n)), (double)this.TOL);
                }
            }
        }
    }

    public void testDct2Slices() {
        DoubleMatrix3D doubleMatrix3D = this.A.copy();
        ((WrapperDoubleMatrix3D)this.A).dct2Slices(true);
        ((WrapperDoubleMatrix3D)this.A).idct2Slices(true);
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    DenseLargeDoubleMatrix3DTest.assertEquals((double)doubleMatrix3D.getQuick(i, j, k), (double)this.A.getQuick(i, j, k), (double)this.TOL);
                }
            }
        }
    }

    public void testDst2Slices() {
        DoubleMatrix3D doubleMatrix3D = this.A.copy();
        ((WrapperDoubleMatrix3D)this.A).dst2Slices(true);
        ((WrapperDoubleMatrix3D)this.A).idst2Slices(true);
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    DenseLargeDoubleMatrix3DTest.assertEquals((double)doubleMatrix3D.getQuick(i, j, k), (double)this.A.getQuick(i, j, k), (double)this.TOL);
                }
            }
        }
    }

    public void testDft2Slices() {
        DoubleMatrix3D doubleMatrix3D = this.A.copy();
        ((WrapperDoubleMatrix3D)this.A).dht2Slices();
        ((WrapperDoubleMatrix3D)this.A).idht2Slices(true);
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    DenseLargeDoubleMatrix3DTest.assertEquals((double)doubleMatrix3D.getQuick(i, j, k), (double)this.A.getQuick(i, j, k), (double)this.TOL);
                }
            }
        }
    }

    public void testGetFft3() {
        DenseLargeDComplexMatrix3D denseLargeDComplexMatrix3D = ((WrapperDoubleMatrix3D)this.A).getFft3();
        denseLargeDComplexMatrix3D.ifft3(true);
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    double[] dArray = ((DComplexMatrix3D)denseLargeDComplexMatrix3D).getQuick(i, j, k);
                    DenseLargeDoubleMatrix3DTest.assertEquals((double)this.A.getQuick(i, j, k), (double)dArray[0], (double)this.TOL);
                    DenseLargeDoubleMatrix3DTest.assertEquals((double)0.0, (double)dArray[1], (double)this.TOL);
                }
            }
        }
    }

    public void testGetIfft3() {
        DenseLargeDComplexMatrix3D denseLargeDComplexMatrix3D = ((WrapperDoubleMatrix3D)this.A).getIfft3(true);
        denseLargeDComplexMatrix3D.fft3();
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    double[] dArray = ((DComplexMatrix3D)denseLargeDComplexMatrix3D).getQuick(i, j, k);
                    DenseLargeDoubleMatrix3DTest.assertEquals((double)this.A.getQuick(i, j, k), (double)dArray[0], (double)this.TOL);
                    DenseLargeDoubleMatrix3DTest.assertEquals((double)0.0, (double)dArray[1], (double)this.TOL);
                }
            }
        }
    }

    public void testGetFft2Slices() {
        DenseLargeDComplexMatrix3D denseLargeDComplexMatrix3D = ((WrapperDoubleMatrix3D)this.A).getFft2Slices();
        denseLargeDComplexMatrix3D.ifft2Slices(true);
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    double[] dArray = ((DComplexMatrix3D)denseLargeDComplexMatrix3D).getQuick(i, j, k);
                    DenseLargeDoubleMatrix3DTest.assertEquals((double)this.A.getQuick(i, j, k), (double)dArray[0], (double)this.TOL);
                    DenseLargeDoubleMatrix3DTest.assertEquals((double)0.0, (double)dArray[1], (double)this.TOL);
                }
            }
        }
    }

    public void testGetIfft2Slices() {
        DenseLargeDComplexMatrix3D denseLargeDComplexMatrix3D = ((WrapperDoubleMatrix3D)this.A).getIfft2Slices(true);
        denseLargeDComplexMatrix3D.fft2Slices();
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    double[] dArray = ((DComplexMatrix3D)denseLargeDComplexMatrix3D).getQuick(i, j, k);
                    DenseLargeDoubleMatrix3DTest.assertEquals((double)this.A.getQuick(i, j, k), (double)dArray[0], (double)this.TOL);
                    DenseLargeDoubleMatrix3DTest.assertEquals((double)0.0, (double)dArray[1], (double)this.TOL);
                }
            }
        }
    }
}

