/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.stat.tfloat.quantile;

import cern.colt.function.tfloat.FloatProcedure;
import cern.jet.stat.BufferSet;
import cern.jet.stat.tfloat.quantile.FloatBuffer;

class FloatBufferSet
extends BufferSet {
    private static final long serialVersionUID = 1L;
    protected FloatBuffer[] buffers;
    private boolean nextTriggerCalculationState;

    public FloatBufferSet(int n, int n2) {
        this.buffers = new FloatBuffer[n];
        this.clear(n2);
    }

    public FloatBuffer _getFirstEmptyBuffer() {
        FloatBuffer floatBuffer = null;
        int n = this.buffers.length;
        while (--n >= 0) {
            if (!this.buffers[n].isEmpty()) continue;
            if (this.buffers[n].isAllocated()) {
                return this.buffers[n];
            }
            floatBuffer = this.buffers[n];
        }
        return floatBuffer;
    }

    public FloatBuffer[] _getFullOrPartialBuffers() {
        int n = 0;
        int n2 = this.buffers.length;
        while (--n2 >= 0) {
            if (this.buffers[n2].isEmpty()) continue;
            ++n;
        }
        FloatBuffer[] floatBufferArray = new FloatBuffer[n];
        int n3 = 0;
        int n4 = this.buffers.length;
        while (--n4 >= 0) {
            if (this.buffers[n4].isEmpty()) continue;
            floatBufferArray[n3++] = this.buffers[n4];
        }
        return floatBufferArray;
    }

    public FloatBuffer[] _getFullOrPartialBuffersWithLevel(int n) {
        int n2 = 0;
        int n3 = this.buffers.length;
        while (--n3 >= 0) {
            if (this.buffers[n3].isEmpty() || this.buffers[n3].level() != n) continue;
            ++n2;
        }
        FloatBuffer[] floatBufferArray = new FloatBuffer[n2];
        int n4 = 0;
        int n5 = this.buffers.length;
        while (--n5 >= 0) {
            if (this.buffers[n5].isEmpty() || this.buffers[n5].level() != n) continue;
            floatBufferArray[n4++] = this.buffers[n5];
        }
        return floatBufferArray;
    }

    public int _getMinLevelOfFullOrPartialBuffers() {
        int n = this.b();
        int n2 = Integer.MAX_VALUE;
        for (int i = 0; i < n; ++i) {
            FloatBuffer floatBuffer = this.buffers[i];
            if (floatBuffer.isEmpty() || floatBuffer.level() >= n2) continue;
            n2 = floatBuffer.level();
        }
        return n2;
    }

    public int _getNumberOfEmptyBuffers() {
        int n = 0;
        int n2 = this.buffers.length;
        while (--n2 >= 0) {
            if (!this.buffers[n2].isEmpty()) continue;
            ++n;
        }
        return n;
    }

    public FloatBuffer _getPartialBuffer() {
        int n = this.buffers.length;
        while (--n >= 0) {
            if (!this.buffers[n].isPartial()) continue;
            return this.buffers[n];
        }
        return null;
    }

    public int b() {
        return this.buffers.length;
    }

    public void clear() {
        this.clear(this.k());
    }

    protected void clear(int n) {
        int n2 = this.b();
        while (--n2 >= 0) {
            this.buffers[n2] = new FloatBuffer(n);
        }
        this.nextTriggerCalculationState = true;
    }

    public Object clone() {
        FloatBufferSet floatBufferSet = (FloatBufferSet)super.clone();
        floatBufferSet.buffers = (FloatBuffer[])floatBufferSet.buffers.clone();
        int n = this.buffers.length;
        while (--n >= 0) {
            floatBufferSet.buffers[n] = (FloatBuffer)floatBufferSet.buffers[n].clone();
        }
        return floatBufferSet;
    }

    public FloatBuffer collapse(FloatBuffer[] floatBufferArray) {
        int n;
        int n2 = 0;
        for (n = 0; n < floatBufferArray.length; ++n) {
            n2 += floatBufferArray[n].weight();
        }
        n = this.k();
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = this.nextTriggerPosition(i, n2);
        }
        float[] fArray = this.getValuesAtPositions(floatBufferArray, lArray);
        for (int i = 1; i < floatBufferArray.length; ++i) {
            floatBufferArray[i].clear();
        }
        FloatBuffer floatBuffer = floatBufferArray[0];
        floatBuffer.values.elements(fArray);
        floatBuffer.weight(n2);
        return floatBuffer;
    }

    public boolean contains(float f) {
        int n = this.buffers.length;
        while (--n >= 0) {
            if (this.buffers[n].isEmpty() || !this.buffers[n].contains(f)) continue;
            return true;
        }
        return false;
    }

    public boolean forEach(FloatProcedure floatProcedure) {
        int n = this.buffers.length;
        while (--n >= 0) {
            int n2 = this.buffers[n].weight();
            while (--n2 >= 0) {
                if (this.buffers[n].values.forEach(floatProcedure)) continue;
                return false;
            }
        }
        return true;
    }

    protected float[] getValuesAtPositions(FloatBuffer[] floatBufferArray, long[] lArray) {
        int n = floatBufferArray.length;
        while (--n >= 0) {
            floatBufferArray[n].sort();
        }
        int[] nArray = new int[floatBufferArray.length];
        float[][] fArrayArray = new float[floatBufferArray.length][];
        int n2 = 0;
        int n3 = floatBufferArray.length;
        while (--n3 >= 0) {
            nArray[n3] = floatBufferArray[n3].size();
            fArrayArray[n3] = floatBufferArray[n3].values.elements();
            n2 += nArray[n3];
        }
        n3 = floatBufferArray.length;
        int n4 = lArray.length;
        int n5 = 0;
        int[] nArray2 = new int[floatBufferArray.length];
        long l = 0L;
        long l2 = lArray[n5];
        float[] fArray = new float[n4];
        if (n2 == 0) {
            for (int i = 0; i < lArray.length; ++i) {
                fArray[i] = Float.NaN;
            }
            return fArray;
        }
        while (n5 < n4) {
            float f = Float.POSITIVE_INFINITY;
            int n6 = -1;
            int n7 = n3;
            while (--n7 >= 0) {
                float f2;
                if (nArray2[n7] >= nArray[n7] || !((f2 = fArrayArray[n7][nArray2[n7]]) <= f)) continue;
                f = f2;
                n6 = n7;
            }
            FloatBuffer floatBuffer = floatBufferArray[n6];
            l += (long)floatBuffer.weight();
            while (l > l2 && n5 < n4) {
                fArray[n5++] = f;
                if (n5 >= n4) continue;
                l2 = lArray[n5];
            }
            int n8 = n6;
            nArray2[n8] = nArray2[n8] + 1;
        }
        return fArray;
    }

    public int k() {
        return this.buffers[0].k;
    }

    public long memory() {
        long l = 0L;
        int n = this.buffers.length;
        while (--n >= 0) {
            l += (long)this.buffers[n].memory();
        }
        return l;
    }

    protected long nextTriggerPosition(int n, long l) {
        long l2 = l % 2L != 0L ? (long)n * l + (l + 1L) / 2L : (this.nextTriggerCalculationState ? (long)n * l + l / 2L : (long)n * l + (l + 2L) / 2L);
        return l2;
    }

    public float phi(float f) {
        float f2 = 0.0f;
        int n = this.buffers.length;
        while (--n >= 0) {
            if (this.buffers[n].isEmpty()) continue;
            f2 += (float)this.buffers[n].weight * this.buffers[n].rank(f);
        }
        return f2 / (float)this.totalSize();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.b(); ++i) {
            if (this.buffers[i].isEmpty()) continue;
            stringBuffer.append("buffer#" + i + " = ");
            stringBuffer.append(this.buffers[i].toString() + "\n");
        }
        return stringBuffer.toString();
    }

    public long totalSize() {
        FloatBuffer[] floatBufferArray = this._getFullOrPartialBuffers();
        long l = 0L;
        int n = floatBufferArray.length;
        while (--n >= 0) {
            l += (long)(floatBufferArray[n].size() * floatBufferArray[n].weight());
        }
        return l;
    }
}

