/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tobject.impl;

import cern.colt.map.tobject.AbstractLongObjectMap;
import cern.colt.map.tobject.OpenLongObjectHashMap;
import cern.colt.matrix.tobject.ObjectMatrix1D;
import cern.colt.matrix.tobject.ObjectMatrix2D;
import cern.colt.matrix.tobject.impl.SelectedSparseObjectMatrix2D;
import cern.colt.matrix.tobject.impl.SparseCCMObjectMatrix2D;
import cern.colt.matrix.tobject.impl.SparseCCObjectMatrix2D;
import cern.colt.matrix.tobject.impl.SparseObjectMatrix1D;
import cern.colt.matrix.tobject.impl.SparseRCMObjectMatrix2D;
import cern.colt.matrix.tobject.impl.SparseRCObjectMatrix2D;

public class SparseObjectMatrix2D
extends ObjectMatrix2D {
    private static final long serialVersionUID = 1L;
    protected AbstractLongObjectMap elements;

    public SparseObjectMatrix2D(Object[][] objectArray) {
        this(objectArray.length, objectArray.length == 0 ? 0 : objectArray[0].length);
        this.assign(objectArray);
    }

    public SparseObjectMatrix2D(int n, int n2) {
        this(n, n2, n * (n2 / 1000), 0.2, 0.5);
    }

    public SparseObjectMatrix2D(int n, int n2, int n3, double d, double d2) {
        this.setUp(n, n2);
        this.elements = new OpenLongObjectHashMap(n3, d, d2);
    }

    protected SparseObjectMatrix2D(int n, int n2, AbstractLongObjectMap abstractLongObjectMap, int n3, int n4, int n5, int n6) {
        this.setUp(n, n2, n3, n4, n5, n6);
        this.elements = abstractLongObjectMap;
        this.isNoView = false;
    }

    public int cardinality() {
        if (this.isNoView) {
            return this.elements.size();
        }
        return super.cardinality();
    }

    public AbstractLongObjectMap elements() {
        return this.elements;
    }

    public void ensureCapacity(int n) {
        this.elements.ensureCapacity(n);
    }

    public SparseCCObjectMatrix2D getColumnCompressed(boolean bl) {
        int n = this.cardinality();
        long[] lArray = this.elements.keys().elements();
        Object[] objectArray = this.elements.values().elements();
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            long l = lArray[i];
            nArray[i] = (int)(l / (long)this.columns);
            nArray2[i] = (int)(l % (long)this.columns);
        }
        return new SparseCCObjectMatrix2D(this.rows, this.columns, nArray, nArray2, objectArray, false, bl);
    }

    public SparseCCMObjectMatrix2D getColumnCompressedModified() {
        SparseCCMObjectMatrix2D sparseCCMObjectMatrix2D = new SparseCCMObjectMatrix2D(this.rows, this.columns);
        int n = this.cardinality();
        long[] lArray = this.elements.keys().elements();
        Object[] objectArray = this.elements.values().elements();
        for (int i = 0; i < n; ++i) {
            int n2 = (int)(lArray[i] / (long)this.columns);
            int n3 = (int)(lArray[i] % (long)this.columns);
            sparseCCMObjectMatrix2D.setQuick(n2, n3, objectArray[i]);
        }
        return sparseCCMObjectMatrix2D;
    }

    public SparseRCObjectMatrix2D getRowCompressed(boolean bl) {
        int n = this.cardinality();
        long[] lArray = this.elements.keys().elements();
        Object[] objectArray = this.elements.values().elements();
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            long l = lArray[i];
            nArray[i] = (int)(l / (long)this.columns);
            nArray2[i] = (int)(l % (long)this.columns);
        }
        return new SparseRCObjectMatrix2D(this.rows, this.columns, nArray, nArray2, objectArray, false, bl);
    }

    public SparseRCMObjectMatrix2D getRowCompressedModified() {
        SparseRCMObjectMatrix2D sparseRCMObjectMatrix2D = new SparseRCMObjectMatrix2D(this.rows, this.columns);
        int n = this.cardinality();
        long[] lArray = this.elements.keys().elements();
        Object[] objectArray = this.elements.values().elements();
        for (int i = 0; i < n; ++i) {
            int n2 = (int)(lArray[i] / (long)this.columns);
            int n3 = (int)(lArray[i] % (long)this.columns);
            sparseRCMObjectMatrix2D.setQuick(n2, n3, objectArray[i]);
        }
        return sparseRCMObjectMatrix2D;
    }

    public synchronized Object getQuick(int n, int n2) {
        return this.elements.get((long)this.rowZero + (long)n * (long)this.rowStride + (long)this.columnZero + (long)n2 * (long)this.columnStride);
    }

    protected boolean haveSharedCellsRaw(ObjectMatrix2D objectMatrix2D) {
        if (objectMatrix2D instanceof SelectedSparseObjectMatrix2D) {
            SelectedSparseObjectMatrix2D selectedSparseObjectMatrix2D = (SelectedSparseObjectMatrix2D)objectMatrix2D;
            return this.elements == selectedSparseObjectMatrix2D.elements;
        }
        if (objectMatrix2D instanceof SparseObjectMatrix2D) {
            SparseObjectMatrix2D sparseObjectMatrix2D = (SparseObjectMatrix2D)objectMatrix2D;
            return this.elements == sparseObjectMatrix2D.elements;
        }
        return false;
    }

    public long index(int n, int n2) {
        return (long)this.rowZero + (long)n * (long)this.rowStride + (long)this.columnZero + (long)n2 * (long)this.columnStride;
    }

    public ObjectMatrix2D like(int n, int n2) {
        return new SparseObjectMatrix2D(n, n2);
    }

    public ObjectMatrix1D like1D(int n) {
        return new SparseObjectMatrix1D(n);
    }

    protected ObjectMatrix1D like1D(int n, int n2, int n3) {
        return new SparseObjectMatrix1D(n, this.elements, n2, n3);
    }

    public synchronized void setQuick(int n, int n2, Object object) {
        long l = (long)this.rowZero + (long)n * (long)this.rowStride + (long)this.columnZero + (long)n2 * (long)this.columnStride;
        if (object == null) {
            this.elements.removeKey(l);
        } else {
            this.elements.put(l, object);
        }
    }

    public ObjectMatrix1D vectorize() {
        SparseObjectMatrix1D sparseObjectMatrix1D = new SparseObjectMatrix1D((int)this.size());
        int n = 0;
        for (int i = 0; i < this.columns; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                Object object = this.getQuick(j, i);
                sparseObjectMatrix1D.setQuick(n++, object);
            }
        }
        return sparseObjectMatrix1D;
    }

    public void trimToSize() {
        this.elements.trimToSize();
    }

    protected ObjectMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        return new SelectedSparseObjectMatrix2D(this.elements, nArray, nArray2, 0);
    }
}

