% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateDenominatorCohortSet.R
\name{generateDenominatorCohortSet}
\alias{generateDenominatorCohortSet}
\title{Identify a set of denominator populations}
\usage{
generateDenominatorCohortSet(
  cdm,
  startDate = NULL,
  endDate = NULL,
  ageGroup = list(c(0, 150)),
  sex = "Both",
  daysPriorHistory = 0,
  strataTable = NULL,
  strataCohortId = NULL,
  strataCohortName = NULL,
  sample = NULL,
  tablePrefix = NULL,
  verbose = FALSE
)
}
\arguments{
\item{cdm}{A CDM reference object}

\item{startDate}{A date indicating the start of the study
period. If NULL, the earliest observation_start_date in the
observation_period table will be used.}

\item{endDate}{A date indicating the end of the study
period. If NULL, the latest observation end date in the observation period
table will be used.}

\item{ageGroup}{A list of age groups for which cohorts will be generated. A
value of \code{list(c(0,17), c(18,30))} would, for example, lead to the creation
of cohorts for those aged from 0 to 17 (up to the day before their 18th
birthday), and from 18 (starting the day of their 18th birthday) to 30 (up
to the day before their 31st birthday).}

\item{sex}{Sex of the cohorts. This can be one or more of: \code{"Male"},
\code{"Female"}, or \code{"Both"}.}

\item{daysPriorHistory}{The number of days of prior history observed in
the database required for an individual to start contributing time in
a cohort.}

\item{strataTable}{A cohort table in the cdm reference to use
to limit cohort entry and exit (with individuals only contributing to a
cohort when they are contributing to the cohort in the strata table).}

\item{strataCohortId}{The cohort definition id for the cohort of interest
in the strata table. Only one stratifying cohort is supported.}

\item{strataCohortName}{Corresponding name for the strata cohort.}

\item{sample}{An integer for which to take a random sample, using
\code{dplyr::slice_sample()}, of the people in the person table eligible to be
included in the cohort set.}

\item{tablePrefix}{The stem for the permanent tables that will
be created when creating the denominator cohorts. Permanent tables will be
created using this stem, and any existing tables that start with this
will be at risk of being dropped or overwritten. If NULL, temporary
tables will be used throughout.}

\item{verbose}{Either TRUE or FALSE. If TRUE, progress will be reported.}
}
\value{
A cohort reference
}
\description{
\code{generateDenominatorCohortSet()} creates a set of cohorts that
can be used for the denominator population in analyses of incidence,
using \code{estimateIncidence()}, or prevalence, using \code{estimatePointPrevalence()}
or \code{estimatePeriodPrevalence()}.
}
\examples{
\donttest{
cdm <- mockIncidencePrevalenceRef(sampleSize = 10000)
cdm$denominator <- generateDenominatorCohortSet(
  cdm = cdm,
  startDate = as.Date("2008-01-01"),
  endDate = as.Date("2018-01-01")
)
}
}
