% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MAD.R
\name{MAD}
\alias{MAD}
\title{Mean absolute difference of rank}
\usage{
MAD(matrix_data)
}
\arguments{
\item{matrix_data}{data matrix of indicator}
}
\value{
It returns a data frame of mean absolute difference of rank for
different methods
}
\description{
Function to calculate the mean absolute difference of rank for different
methods
}
\details{
Function to calculate the mean absolute difference of rank for different
methods. Create the matrix of ranking for different columns, the rank is the
high value is the first. Calculate the different in absolute values for
different columns and calculate the mean for different methods
}
\examples{

data("Education")
Indicator_MPI=linear_aggregation_MPI(Education)
Indicator_AMPI=linear_aggregation_AMPI(Education)
Indicator_GA=geometric_aggregation(Education)
All_Indicator=cbind(Indicator_MPI,Indicator_AMPI,Indicator_GA)
MAD=MAD(All_Indicator)
print(MAD)

}
\references{
Matteo Mazziotta & Adriano Pareto, 2018. "Measuring Well-Being
Over Time: The Adjusted Mazziotta–Pareto Index Versus Other Non-compensatory
Indices," Social Indicators Research: An International and Interdisciplinary
Journal for Quality-of-Life Measurement, Springer, vol. 136(3), pages
967-976, April
}
\keyword{Absolute}
\keyword{Difference}
\keyword{MAD}
\keyword{Mean}
