% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{HeatmapSelection}
\alias{HeatmapSelection}
\title{A function to select a group of objects via the similarity heatmap.}
\usage{
HeatmapSelection(Data, type = c("data", "dist", "clust", "sim"),
  distmeasure = "tanimoto", normalize = FALSE, method = NULL,
  linkage = "flexible", cutoff = NULL, percentile = FALSE,
  dendrogram = NULL, width = 7, height = 7)
}
\arguments{
\item{Data}{The data of which a heatmap should be drawn.}

\item{type}{indicates whether the provided matrices in "List" are either data matrices, distance
matrices or clustering results obtained from the data. If type="dist" the calculation of the distance
matrices is skipped and if type="clusters" the single source clustering is skipped.
Type should be one of "data", "dist" or "clusters".}

\item{distmeasure}{The distance measure. Should be one of "tanimoto", "euclidean", "jaccard", "hamming". Defaults to "tanimoto".}

\item{normalize}{Logical. Indicates whether to normalize the distance matrices or not, defaults to c(FALSE, FALSE) for two data sets. This is recommended if different distance types are used. More details on normalization in \code{Normalization}.}

\item{method}{A method of normalization. Should be one of "Quantile","Fisher-Yates", "standardize","Range" or any of the first letters of these names. Default is NULL.}

\item{linkage}{Choice of inter group dissimilarity (character). Defaults to "flexible".}

\item{cutoff}{Optional. If a cutoff value is specified, all values lower are
put to zero while all other values are kept. This helps to highlight the
most similar objects. Default is NULL.}

\item{percentile}{Logical. The cutoff value can be a percentile. If one want
the cutoff value to be the 90th percentile of the data, one should specify
cutoff = 0.90 and percentile = TRUE. Default is FALSE.}

\item{dendrogram}{Optional. If the clustering results of the data is already
available and should not be recalculated, this results can be provided here.
Otherwise, it will be calculated given the data. This is necessary to have
the objects in their order of clustering on the plot. Default is NULL.}

\item{width}{The width of the plot to be made. This can be adjusted since
the default size might not show a clear picture. Default is 7.}

\item{height}{The height of the plot to be made. This can be adjusted since
the default size might not show a clear picture. Default is 7.}
}
\value{
A heatmap with the names of the objects on the right and bottom.
Once points are selected, it will return the names of the objects that are
in the selected square provided that these show similarity among each other.
}
\description{
The function \code{HeatmapSelection} plots the similarity values between
objects. The plot is similar to the one produced by
\code{SimilarityHeatmap} but without the dendrograms on the sides. The
function is rather explorative and experimental and is to be used with some
caution. By clicking in the plot, the user can select a group of objects
of interest. See more in \code{Details}.

A similarity heatmap is created in the same way as in
\code{SimilarityHeatmap}. The user is now free to select two points on the
heatmap. It is advised that these two points are in opposite corners of a
square that indicates a high similarity among the objects. The points do
not have to be the exact corners of the group of interest, a little
deviation is allowed as rows and columns of the selected subset of the
matrix with sum equal to 1 are filtered out. A sum equal to one, implies
that the compound is only similar to itself.

The function is meant to be explorative but is experimental. The goal was to
make the selection of interesting objects easier as sometimes the labels
of the dendrograms are too distorted to be read. If the figure is exported
to a pdf file with an appropriate width and height, the labels can be become
readable again.
}
\examples{

\dontrun{
data(fingerprintMat)

MCF7_F = Cluster(fingerprintMat,type="data",distmeasure="tanimoto",normalize=FALSE,
method=NULL,clust="agnes",linkage="flexible",gap=FALSE,maxK=55)

HeatmapSelection(Data=MCF7_F$DistM,type="dist",cutoff=0.90,percentile=TRUE,
dendrogram=MCF7_F,width=7,height=7)
}

}
