% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{WonM}
\alias{WonM}
\title{Weighting on membership}
\usage{
WonM(List, type = c("data", "dist", "clusters"), distmeasure = c("tanimoto",
  "tanimoto"), normalize = c(FALSE, FALSE), method = c(NULL, NULL),
  nrclusters = seq(5, 25, 1), clust = "agnes", linkage = c("flexible",
  "flexible"), alpha = 0.625)
}
\arguments{
\item{List}{A list of data matrices. It is assumed the rows are corresponding with the objects.}

\item{type}{indicates whether the provided matrices in "List" are either data matrices, distance
matrices or clustering results obtained from the data. If type="dist" the calculation of the distance
matrices is skipped and if type="clusters" the single source clustering is skipped.
Type should be one of "data", "dist" or"clusters".}

\item{distmeasure}{A vector of the distance measures to be used on each data matrix. Should be one of "tanimoto", "euclidean", "jaccard", "hamming". Defaults to c("tanimoto","tanimoto").}

\item{normalize}{Logical. Indicates whether to normalize the distance matrices or not, defaults to c(FALSE, FALSE) for two data sets. This is recommended if different distance types are used. More details on normalization in \code{Normalization}.}

\item{method}{A method of normalization. Should be one of "Quantile","Fisher-Yates", "standardize","Range" or any of the first letters of these names. Default is c(NULL,NULL) for two data sets.}

\item{nrclusters}{A sequence of numbers of clusters to cut the dendrogram in. Defaults is a sequence of 5 to 25.}

\item{clust}{Choice of clustering function (character). Defaults to "agnes".}

\item{linkage}{Choice of inter group dissimilarity (character) for each data set. Defaults to c("flexible", "flexible") for two data sets.}

\item{alpha}{The parameter alpha to be used in the "flexible" linkage of the agnes function. Defaults to 0.625 and is only used if the linkage is set to "flexible"}
}
\value{
The returned value is a list of two elements:
\item{DistM}{The resulting incidence matrix}
\item{Clust}{The resulting clusters}
The value has class 'WonM'.
}
\description{
Weighting on Membership (WonM) is similar to CEC as the dendrograms are divided into clusters for a range of values for the
number of clustes. However, instead of weighting the sum of the incidences matrices, the final matrix for clustering is the normal sum of 
all incidence matrices.
}
\examples{
data(fingerprintMat)
data(targetMat)
L=list(fingerprintMat,targetMat)

MCF7_WonM=WonM(List=L,type="data",distmeasure=c("tanimoto", "tanimoto"),
normalize=c(FALSE,FALSE),method=c(NULL,NULL),nrclusters=seq(5,25,1),
clust="agnes",linkage=c("flexible","flexible"),alpha=0.625)
}
