% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InterVA5.get.symptoms.R
\name{whyNotCOD}
\alias{whyNotCOD}
\title{Get the symptoms with the largest conditional probability (symptom | cause) using VA data.}
\usage{
whyNotCOD(data, IDs = NULL, cause = NULL, pretty = TRUE,
  includeAll = FALSE)
}
\arguments{
\item{data}{The input data that InterVA5 used to assign the causes of death.}

\item{IDs}{A vector that contains the IDs for each death (note that all of IDs are contained
in data$ID and object$ID).}

\item{cause}{A string giving the name of the cause for which the conditional probabilities will
be returned.}

\item{pretty}{A logical indicating if you want the results in an easy-to-read format (default is `TRUE`).}

\item{includeAll}{A logical indicating if you want all of the symptoms included in the output
(even those which are absent or have a value of missing/no) (default is `FALSE` which only includes
symptoms that are present).}
}
\value{
\item{dist.cod}{A list of results for each death (organized by ID).  For each death, a list
is returned that includes the death's ID, the cause, and a vector of strings listing a symptom,
it if contributes to the cause assignment (if includeAll = TRUE), and the conditional probability of
observing the symptom given that the death is due to this cause.}
}
\description{
The function takes takes verbal autopsy data (which can be passed to InterVA5() to assign
causes of death), and returns the the symptoms that contribute to the assignment of a 
particular cause of death.  This function differs from getTopSymptom() in that the user
specified the cause for which they would like the results.  This is an interactive function
in the sense that if a cause is not provided as an argument, then the function will print out
a numbered list of possible causes and the user can enter in the number to identify the
cause of interest.
}
\examples{

\dontrun{
data(RandomVA5)
whyNotCOD(data = RandomVA5,
          IDs = RandomVA5$ID[1],
          pretty = TRUE,
          includeAll = FALSE)

data(causetextV5)
causetextV5[22, 2]
whyNotCOD(data = RandomVA5,
          IDs = RandomVA5$ID[1],
          cause = causetextV5[22, 2], 
          pretty = TRUE,
          includeAll = FALSE)
}

}
\seealso{
\code{\link{InterVA5}, \link{whyNotCOD}}
}
\author{
Jason Thomas, Zehang LI, Tyler McCormick, Sam Clark
}
\keyword{interVA}
