% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{param.default}
\alias{param.default}
\title{Default parameter list for \code{InterpretMSSpectrum}.}
\format{
A data frame with 22 observations on the following 3 variables:
 \describe{
 \item{\code{ionization}}{ESI or APCI -- will influence expected peak width and precision as well as adducts.}
 \item{\code{ionmode}}{positive or negative -- will influence expected adducts.}
 \item{\code{allowed_elements}}{Passed to Rdisop in formula generation.}
 \item{\code{maxElements}}{Passed to Rdisop in formula generation.}
 \item{\code{minElements}}{Passed to Rdisop in formula generation.}
 \item{\code{substitutions}}{Will be deprecated in the future.}
 \item{\code{quick_isos}}{TRUE = via Rdisop, FALSE = via enviPat (often more correct)}
 \item{\code{score_cutoff}}{Specifies initial filtering step threshold per fragment. Sum Formulas with score_i < score_cutoff*max(score) will be removed.}
 \item{\code{neutral_loss_cutoff}}{Specifies the allowed deviation in mDa for neutral losses to be accepted from the provided neutral loss list.}
 }
}
\usage{
data(param.default)
}
\description{
Default parameter list for \code{InterpretMSSpectrum}.
}
\details{
Default parameter list used by \code{\link{InterpretMSSpectrum}}, serving also as a template 
    for custom lists. Basically every option which needs to be modified rarely went in here. Specific 
    parameter set modifications (i.e. for 'APCIpos') are provided and can be called using the character 
    string as a shortcut. Alternatively, a named list can be provided where all contained parameters 
    will receive the new specified values.
}
\keyword{datasets}
