% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iso_ratio.R
\name{iso_ratio}
\alias{iso_ratio}
\title{iso_ratio}
\usage{
iso_ratio(
  data = data.frame(X = rnorm(10), Y = rnorm(10)),
  method = c("PBP", "PAI", "LRS")[1],
  thr = 1
)
}
\arguments{
\item{data}{data.frame with two columns specifying data for isotope 1 and 2 respectively.}

\item{method}{Method to calculate the isotope ratio.}

\item{thr}{Threshold between 0..1 to limit the peaks scans used in the calculation (1=all scans, 0=apex only).}
}
\value{
A single numeric value. The robust ratio estimate calculated from \code{data}.
}
\description{
\code{iso_ratio} will calculate a robust estimate of an
isotopic ratio between intensity values of 2 mass traces.
}
\details{
Within \code{\link{ic_app}} we compute estimates for isotope ratios
using raw data and several processing steps. \code{iso_ratio} is internally
used to perform this calculation and could be used in an external data
processing pipeline without the app context.
However, users would need to extract intensity vectors of isotope peaks
from raw data independently.
\emph{\strong{Note!}} All non-finite values and x==0 will be removed before calculation.
}
\examples{
peak1 <- 1+cos(x = seq(-pi, pi, length.out=100))
peak2 <- 0.05*peak1*runif(n=100, min=1, max=1.01)
iso_ratio(data=cbind(peak1, peak2))

}
