% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit-mirt.R
\name{control_mirt}
\alias{control_mirt}
\title{Control aspects of fitting a model in mirt}
\usage{
control_mirt(
  SE = TRUE,
  method = "EM",
  quadpts = NULL,
  control = list(),
  technical = list(),
  ...
)
}
\arguments{
\item{SE, method, quadpts, ...}{These arguments are passed to and documented
in \code{\link[mirt:mirt]{mirt::mirt()}}. They can be used to tweak the estimation algorithm.}

\item{control}{List of arguments passed to argument \code{control} of
\code{\link[mirt:mirt]{mirt::mirt()}}.}

\item{technical}{List of arguments passed to argument \code{technical} of
\code{\link[mirt:mirt]{mirt::mirt()}}.}
}
\value{
A list with one element for every argument of \code{control_mirt()}.
}
\description{
This function should be used to generate the \code{control} argument of the
\code{\link[=fit.irtree_model]{fit()}} function.
}
\examples{
control_mirt(SE = FALSE,
             method = "QMCEM",
             quadpts = 4455,
             technical = list(NCYCLES = 567),
             TOL = .001)
control_mirt(method = "MHRM",
             draws = 5544)
}
