/*
 * Decompiled with CFR 0.152.
 */
package j4r.net.server;

import java.io.Serializable;
import java.security.InvalidParameterException;

public class ServerConfiguration
implements Serializable {
    private static final long serialVersionUID = 20111222L;
    protected final int numberOfClientThreads;
    protected final int maxSizeOfWaitingList;
    protected final int outerPort;
    protected final Integer innerPort;

    public ServerConfiguration(int numberOfClientThreads, int maxSizeOfWaitingList, int outerPort, Integer internalPort) {
        if (numberOfClientThreads < 0 || numberOfClientThreads > 10) {
            throw new InvalidParameterException("Number of client threads should be between 1 and 10");
        }
        this.numberOfClientThreads = numberOfClientThreads;
        if (outerPort < 1024 || outerPort > 49151) {
            throw new InvalidParameterException("The outer port must be between 1024 and 49151");
        }
        this.outerPort = outerPort;
        if (internalPort != null && (internalPort < 1024 || internalPort > 49151)) {
            throw new InvalidParameterException("The inner port must be between 1024 and 49151");
        }
        this.innerPort = internalPort;
        this.maxSizeOfWaitingList = maxSizeOfWaitingList < 0 ? 0 : maxSizeOfWaitingList;
    }

    public ServerConfiguration(int outerPort) {
        if (outerPort < 1024 || outerPort > 49151) {
            throw new InvalidParameterException("The outer port must be between 1024 and 49151");
        }
        this.outerPort = outerPort;
        this.innerPort = null;
        this.numberOfClientThreads = 1;
        this.maxSizeOfWaitingList = 0;
    }
}

