% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QR_functions.R
\name{add_indicator}
\alias{add_indicator}
\title{Adding an indicator in QR_matrix objects}
\usage{
add_indicator(x, indicator, variable_name, ...)
}
\arguments{
\item{x}{a \code{\link{QR_matrix}} or \code{\link{mQR_matrix}} object}

\item{indicator}{a \code{vector} or a \code{data.frame} (cf. details).}

\item{variable_name}{a string containing the name of the variables to add.}

\item{...}{other parameters of the function \code{\link[base]{merge}}.}
}
\value{
This function returns the same object, enhanced with the chosen
indicator. So if the input \code{x} is a QR_matrix, an object of class
\code{QR_matrix} is returned. If the input \code{x} is a mQR_matrix, an
object of class \code{mQR_matrix} is returned.
}
\description{
Function to add indicators in \code{\link{QR_matrix}} objects.
}
\details{
The function \code{add_indicator()} adds the chosen indicator to the
values matrix of a quality report. Therefore, because said indicator isn't
added in the modalities matrix, it cannot be used to calculate a score
(except for weighting). Before using the added variable for score
calculation, it will have to be coded with the function
\code{\link{recode_indicator_num}}.

The new indicator can be a \code{vector} or a \code{data.frame}. In both
cases, its format must allow for pairing:
\itemize{
\item a \code{vector}'s elements must be named and these names must match those
of the quality report (variable "series");
\item a \code{data.frame} must contain a "series" column that matches with the
quality report's series.
}
}
\seealso{
\link[=fr-add_indicator]{Traduction française}

Other var QR_matrix manipulation: 
\code{\link{QR_var_manipulation}},
\code{\link{recode_indicator_num}()}
}
\concept{var QR_matrix manipulation}
