/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JRI;

import org.rosuda.JRI.Mutex;
import org.rosuda.JRI.REXP;
import org.rosuda.JRI.RMainLoopCallbacks;

public class Rengine
extends Thread {
    public static int DEBUG;
    static Rengine mainEngine;
    boolean died = false;
    boolean alive = false;
    boolean runLoop;
    boolean loopRunning;
    String[] args;
    Mutex Rsync = new Mutex();
    RMainLoopCallbacks callback;

    public static long getVersion() {
        return 259L;
    }

    public static boolean versionCheck() {
        return Rengine.getVersion() == Rengine.rniGetVersion();
    }

    public static Rengine getMainEngine() {
        return mainEngine;
    }

    public Rengine(String[] stringArray, boolean bl, RMainLoopCallbacks rMainLoopCallbacks) {
        this.runLoop = bl;
        this.loopRunning = false;
        this.args = stringArray;
        this.callback = rMainLoopCallbacks;
        mainEngine = this;
        this.start();
        while (!this.alive && !this.died) {
            Rengine.yield();
        }
    }

    public native int rniSetupR(String[] var1);

    synchronized int setupR() {
        return this.setupR(null);
    }

    synchronized int setupR(String[] stringArray) {
        int n = this.rniSetupR(stringArray);
        if (n == 0) {
            this.alive = true;
            this.died = false;
        } else {
            this.alive = false;
            this.died = true;
        }
        return n;
    }

    public synchronized native long rniParse(String var1, int var2);

    public synchronized native long rniEval(long var1, long var3);

    public synchronized native String rniGetString(long var1);

    public synchronized native String[] rniGetStringArray(long var1);

    public synchronized native int[] rniGetIntArray(long var1);

    public synchronized native double[] rniGetDoubleArray(long var1);

    public synchronized native long[] rniGetVector(long var1);

    public synchronized native long rniPutString(String var1);

    public synchronized native long rniPutStringArray(String[] var1);

    public synchronized native long rniPutIntArray(int[] var1);

    public synchronized native long rniPutDoubleArray(double[] var1);

    public synchronized native long rniPutVector(long[] var1);

    public synchronized native long rniGetAttr(long var1, String var3);

    public synchronized native void rniSetAttr(long var1, String var3, long var4);

    public synchronized native long rniCons(long var1, long var3);

    public synchronized native long rniCAR(long var1);

    public synchronized native long rniCDR(long var1);

    public synchronized native long rniPutList(long[] var1);

    public synchronized native long[] rniGetList(long var1);

    public static native long rniGetVersion();

    public native int rniStop(int var1);

    public synchronized native void rniAssign(String var1, long var2, long var4);

    public synchronized native int rniExpType(long var1);

    public native void rniRunMainLoop();

    public synchronized native void rniIdle();

    public void addMainLoopCallbacks(RMainLoopCallbacks rMainLoopCallbacks) {
        this.callback = rMainLoopCallbacks;
    }

    public void startMainLoop() {
        this.runLoop = true;
    }

    public void jriWriteConsole(String string) {
        if (this.callback != null) {
            this.callback.rWriteConsole(this, string);
        }
    }

    public void jriBusy(int n) {
        if (this.callback != null) {
            this.callback.rBusy(this, n);
        }
    }

    public String jriReadConsole(String string, int n) {
        String string2;
        if (DEBUG > 0) {
            System.out.println("Rengine.jreReadConsole BEGIN " + Thread.currentThread());
        }
        this.Rsync.unlock();
        String string3 = string2 = this.callback == null ? null : this.callback.rReadConsole(this, string, n);
        if (!this.Rsync.safeLock()) {
            String string4 = "\n>>JRI Warning: jriReadConsole detected a possible deadlock [" + this.Rsync + "][" + Thread.currentThread() + "]. Proceeding without lock, but this is inherently unsafe.\n";
            this.jriWriteConsole(string4);
            System.err.print(string4);
        }
        if (DEBUG > 0) {
            System.out.println("Rengine.jreReadConsole END " + Thread.currentThread());
        }
        return string2;
    }

    public void jriShowMessage(String string) {
        if (this.callback != null) {
            this.callback.rShowMessage(this, string);
        }
    }

    public void jriLoadHistory(String string) {
        if (this.callback != null) {
            this.callback.rLoadHistory(this, string);
        }
    }

    public void jriSaveHistory(String string) {
        if (this.callback != null) {
            this.callback.rSaveHistory(this, string);
        }
    }

    public String jriChooseFile(int n) {
        if (this.callback != null) {
            return this.callback.rChooseFile(this, n);
        }
        return null;
    }

    public void jriFlushConsole() {
        if (this.callback != null) {
            this.callback.rFlushConsole(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized REXP eval(String string) {
        if (DEBUG > 0) {
            System.out.println("Rengine.eval(" + string + "): BEGIN " + Thread.currentThread());
        }
        boolean bl = this.Rsync.safeLock();
        try {
            long l;
            long l2 = this.rniParse(string, 1);
            if (l2 > 0L && (l = this.rniEval(l2, 0L)) > 0L) {
                REXP rEXP = new REXP(this, l);
                if (DEBUG > 0) {
                    System.out.println("Rengine.eval(" + string + "): END (OK)" + Thread.currentThread());
                }
                REXP rEXP2 = rEXP;
                return rEXP2;
            }
        }
        finally {
            if (bl) {
                this.Rsync.unlock();
            }
        }
        if (DEBUG > 0) {
            System.out.println("Rengine.eval(" + string + "): END (ERR)" + Thread.currentThread());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized REXP idleEval(String string) {
        int n = this.Rsync.tryLock();
        if (n == 1) {
            return null;
        }
        boolean bl = n == 0;
        try {
            long l;
            long l2 = this.rniParse(string, 1);
            if (l2 > 0L && (l = this.rniEval(l2, 0L)) > 0L) {
                REXP rEXP;
                REXP rEXP2 = rEXP = new REXP(this, l);
                return rEXP2;
            }
        }
        finally {
            if (bl) {
                this.Rsync.unlock();
            }
        }
        return null;
    }

    public synchronized boolean waitForR() {
        return this.alive;
    }

    public void end() {
        this.alive = false;
        this.interrupt();
    }

    public void run() {
        if (DEBUG > 0) {
            System.out.println("Starting R...");
        }
        if (this.setupR(this.args) == 0) {
            while (this.alive) {
                try {
                    if (this.runLoop) {
                        if (DEBUG > 0) {
                            System.out.println("***> launching main loop:");
                        }
                        this.loopRunning = true;
                        this.rniRunMainLoop();
                        this.loopRunning = false;
                        if (DEBUG > 0) {
                            System.out.println("***> main loop finished:");
                        }
                        System.exit(0);
                    }
                    Rengine.sleep(100L);
                    if (!this.runLoop) continue;
                    this.rniIdle();
                }
                catch (InterruptedException interruptedException) {
                    Rengine.interrupted();
                }
            }
            this.died = true;
            if (DEBUG > 0) {
                System.out.println("Terminating R thread.");
            }
        } else {
            System.err.println("Unable to start R");
        }
    }

    static {
        try {
            System.loadLibrary("jri");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println("Cannot find JRI native library!\n");
            unsatisfiedLinkError.printStackTrace();
            System.exit(1);
        }
        DEBUG = 0;
        mainEngine = null;
    }
}

