/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.rhelp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import org.rosuda.JGR.rhelp.Tracer;
import org.rosuda.JGR.rhelp.Value;

public class IndexStream {
    private URL iInputURL;
    private int iIndex;
    private Vector iData;
    private static final String cIncludeDirective = "include";

    public IndexStream(URL uRL) {
        this.iInputURL = uRL;
        this.iIndex = 0;
        this.iData = new Vector();
        this.readStream();
    }

    public Value popEntry() {
        if (this.iIndex < 0) {
            this.iIndex = 0;
        }
        if (this.iIndex >= this.iData.size()) {
            return null;
        }
        ++this.iIndex;
        return (Value)this.iData.elementAt(this.iIndex - 1);
    }

    public void pushEntry(Value value) {
        if (this.iIndex < 0) {
            this.iIndex = 0;
        }
        if (this.iIndex >= this.iData.size()) {
            this.iIndex = this.iData.size();
        }
        this.iData.insertElementAt(value, this.iIndex);
    }

    public void readStream() {
        block4: {
            try {
                InputStream inputStream = this.iInputURL.openStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                String string = bufferedReader.readLine();
                while (string != null) {
                    this.parseLine(string);
                    string = bufferedReader.readLine();
                }
                bufferedReader.close();
                inputStream.close();
            }
            catch (IOException iOException) {
            }
            catch (Exception exception) {
                Tracer.write("exction opening " + this.iInputURL.toString() + "\n");
                Tracer.write("string: " + exception.toString() + "\n");
                if (exception.getMessage() == null) break block4;
                Tracer.write("info: " + exception.getMessage() + "\n");
            }
        }
    }

    public void parseLine(String string) {
        if (string.length() == 0) {
            return;
        }
        if (string.startsWith("#")) {
            return;
        }
        if (string.startsWith("\t") || string.startsWith(" ")) {
            this.parseContinuation(string);
        }
        this.parseKeyValue(string);
    }

    public void parseContinuation(String string) {
        if (this.iData.size() < 1) {
            return;
        }
        String string2 = string.trim();
        Value value = (Value)this.iData.lastElement();
        value.addToValue(string2);
    }

    public void parseKeyValue(String string) {
        int n = string.indexOf(":");
        if (n < 1) {
            return;
        }
        String string2 = string.substring(0, n);
        String string3 = null;
        try {
            string3 = string.substring(n + 1).trim();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            string = "";
        }
        if (string2.equalsIgnoreCase(cIncludeDirective)) {
            try {
                URL uRL = new URL(this.iInputURL, string3);
                Tracer.write("URL to be included expands to " + uRL.toString() + "\n");
                IndexStream indexStream = new IndexStream(uRL);
                if (indexStream != null) {
                    Value value = indexStream.popEntry();
                    while (value != null) {
                        this.iData.addElement(value);
                        value = indexStream.popEntry();
                    }
                }
                indexStream = null;
            }
            catch (MalformedURLException malformedURLException) {
                Tracer.write("error parsing include URL " + string3 + "\n");
                return;
            }
        } else {
            Value value = new Value(string2, string3);
            this.iData.addElement(value);
        }
    }
}

