% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jmo_long.R
\name{jmo_long}
\alias{jmo_long}
\title{An integrated function for reconstructing data and do the joint modelling}
\usage{
jmo_long(long_data, surv_data, out, FE, RE, NP, ID, cate = NULL,
  intcpt = 1, quad.points = 20, max.iter = 10000, quiet = TRUE,
  do.trace = FALSE)
}
\arguments{
\item{long_data}{Data matrix for longitudinal in long format. The time variable should be labeled 'time'.}

\item{surv_data}{Data matrix for competing risks data. Each subject has one row of observation (as opposed to the long_data).
First and second column should be the observed event time and censoring indicator, respectively. 
The coding for the censoring indicator is as follows: 0 - censored events, 1 - risk 1, 2 - risk 2. Two competing risks are assumed.}

\item{out}{Column name for outcome variable in long_data.}

\item{FE}{Vector of column names that correspond to the fixed effects in long_data. If missing, then all columns except for the outcome and ID columns will be considered.}

\item{RE}{Types/Vector of random effects in long_data. The available type are "intercept", "linear", "quadratic" (time-related random effect specification) or other covariates in the input dataset.}

\item{NP}{Vector of column names that correspond to the non-proportional odds covariates. It won't run the model if NP is not specified.}

\item{ID}{Column name for subject ID number in long_data.}

\item{cate}{Vector of categorical variables in long_data.}

\item{intcpt}{Specify either 0 or 1. Default is set as 1. 0 means no intercept in random effect.}

\item{quad.points}{Number of quadrature points used in the EM procedure. Default is 20. Must be an even number. Larger values means higher accuracy but more time-consuming.}

\item{max.iter}{Max iterations. Default is 10000.}

\item{quiet}{Logical. Print progress of function. Default is TRUE.}

\item{do.trace}{Logical. Print the parameter estimates during the iterations. Default is FALSE.}
}
\value{
Object of class \code{JMcmprsk} with elements
  \tabular{ll}{
      \code{vcmatrix}    \tab  The variance-covariance matrix for all the parameters. The parameters are in the order: \eqn{\beta}, \eqn{\sigma^2}, \eqn{\gamma}, \eqn{\nu}, and \eqn{\Sigma}. The elements in \eqn{\Sigma} are output in the order along the main diagonal line, then the second main diagonal line, and so on. \cr
      \code{betas} \tab The point  estimates of \eqn{\beta}. \cr
      \code{se_betas} \tab The standard error estimate of \eqn{\beta}. \cr
      \code{gamma_matrix} \tab  The point  estimate of \eqn{\gamma}. \cr
      \code{se_gamma_matrix}   \tab  The standard error estimate of \eqn{\gamma}. \cr
      \code{v_estimate} \tab The point  estimate of \eqn{\nu}. \cr
      \code{se_v_estimate}    \tab The standard error estimate of \eqn{\nu}. \cr
      \code{sigma2_val}     \tab  The point estimate of \eqn{\sigma^2}.\cr
      \code{se_sigma2_val}     \tab  The standard error estimate of \eqn{\sigma^2}.\cr
      \code{sigma_matrix}     \tab The point estimate of \eqn{\Sigma} (only the upper triangle portion of the matrix is output).\cr
      \code{se_sigma}     \tab The standard error estimate of \eqn{\Sigma}.The standard errors are given in this order: main diagonal, the second main diagonal, and so on. \cr
      \code{loglike}     \tab Log Likelihood.\cr
  }
}
\description{
Reconstruct data into a regular longitudinal format as a refined dataset and do joint modelling for this refined data with ordinal outcome.
}
\examples{
\dontrun{ 
  require(tidyverse)
  yfile = system.file("extdata", "ninds_nrank_y.txt", package = "JMcmprsk")
  cfile = system.file("extdata", "ninds_nrank_c.txt", package = "JMcmprsk")
  mfile = system.file("extdata", "ninds_nrank_m.txt", package = "JMcmprsk")
  yread = read.table(yfile, header = TRUE)
  cread = read.table(cfile, header = TRUE)
  mread = read.table(mfile)
  # make a raw yread: this is a dataset like what users usually have
  yread <- yread[, -c(2:4)]
  # create an ID column for each subject and add it to yread
  ID <- vector()
  for (i in 1:nrow(mread)) {
  ID <- c(ID, replicate(mread[i, 1], i))
  }
  yread <- data.frame(ID, yread)
  ID <- c(1:nrow(cread))
  #Create two categorical variables and add them into yread
  set.seed(100)
  sex <- sample(c("Feamle", "Male"), nrow(mread), replace = T)
  race <- sample(c("White", "Black", "Asian", "Hispanic"), nrow(mread), replace = T)
  cate_var <- data.frame(ID, sex, race)
  yread <- left_join(yread, cate_var, by = "ID")
  # run jmo_long function again for yread file with two added categorical variables
  res1 <- jmo_long(yread, cread, out = "Y", 
  FE = c("group", "time3", "time6", "time12", "mrkprior", 
  "smlves", "lvORcs", "smlves.group", "lvORcs.group"), cate = c("sex", "race"), 
  RE = "intercept", NP = c("smlves", "lvORcs", "sex", "race"), ID = "ID",intcpt = 1, 
  quad.points = 12, max.iter = 1000, quiet = FALSE)
  }
}
\seealso{
\code{\link{jmo}}
}
