% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count2d.R
\name{count2d}
\alias{count2d}
\title{Create a matrix of counts.}
\usage{
count2d(xb, yb, nb)
}
\arguments{
\item{xb}{a vector of integers.}

\item{yb}{a vector of integers.}

\item{nb}{a vector of length 2 that provides the number of bins for the 2D histogram on \code{x} and \code{y}.}
}
\value{
A matrix with \code{nb[1]} rows and \code{nb[2]} columns with counts.
It serves as the input for two-dimensional histogram smoothing.
}
\description{
Count the number of occurrences of pairs of positive integers in two vectors,
producing a matrix.
}
\details{
This function builds a two-dimensional histogram, based on two two vectors of bin numbers (obtained
with \code{binit}). Rows where \code{x[i] > nb[1]}  or \code{y[i] > nb[2]} are discarded without a warning.
}
