% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ps2DSignal.R
\name{ps2DSignal}
\alias{ps2DSignal}
\title{Two-dimensional penalized signal regression using P-splines.}
\usage{
ps2DSignal(
  y,
  M,
  p1,
  p2,
  M_type = "stacked",
  M1_index = c(1:p1),
  M2_index = c(1:p2),
  Pars = rbind(c(1, p1, 10, 3, 1, 2), c(1, p2, 10, 3, 1, 2)),
  ridge_adj = 1e-06,
  M_pred = M,
  y_predicted = NULL,
  family = "gaussian",
  link = "default",
  m_binomial = 1 + 0 * y,
  wts = 1 + 0 * y,
  r_gamma = 1 + 0 * y,
  int = TRUE,
  se_pred = 2
)
}
\arguments{
\item{y}{a response vector of length \code{m}, usually continuous, binary/bimomial or counts.}

\item{M}{The signal/image regressors, which are either "stacked" or "unfolded",
with dimensions (\code{m} * \code{p1}) by \code{p2} (i.e. \code{m} stacked matrices each of \code{p1} by \code{p2})
or with dimensions \code{m} by (\code{p1} * \code{p2}) (i.e. regressor matrix with \code{m} regressor rows, each with column
length \code{p1 * p2}), respectively.}

\item{p1}{the row dimension of the image.}

\item{p2}{the column dimension of the image.}

\item{M_type}{"stacked" (signal as matrix) or "unfolded" (signal as vector).}

\item{M1_index}{an index of length \code{p1} for rows of regressor matrix (default is a simple sequence).}

\item{M2_index}{an index of length \code{p2} for columns of regressor matrix (default is a simple sequence).}

\item{Pars}{a matrix of 2 rows, where the first and second row
sets the P-spline paramters for \code{x} and \code{y}, respectively.
Each row consists of: \code{min max nseg bdeg lambda pord}.
The \code{min} and \code{max} set the ranges, \code{nseg} (default 10)
is the number of evenly spaced segments between \code{min} and \code{max},
\code{bdeg} is the degree of the basis (default 3 for cubic),
\code{lambda} is the (positive) tuning parameter for the penalty (default 1),
\code{pord} is the number for the order of the difference penalty (default 2).}

\item{ridge_adj}{A ridge penalty tuning parameter (usually set to small value, default \code{1e-6}, to stabilize estimation).}

\item{M_pred}{(e.g. stacked (\code{q} * \code{p1}) by \code{p2}
signal inputs  or (unfolded) \code{q} by (\code{p1} * \code{p2}) signal
inputs for \code{q} new predictions.}

\item{y_predicted}{a vector of responses from a cv data set (assoc. with \code{M_pred}), when \code{family = "gaussian"}.}

\item{family}{the response distribution, e.g.
\code{"gaussian", "binomial", "poisson", "Gamma"} distribution. Quotes are needed. Default is "gaussian".}

\item{link}{the link function, one of \code{"identity"}, \code{"log"}, \code{"sqrt"},
\code{"logit"}, \code{"probit"}, \code{"cloglog"}, \code{"loglog"}, \code{"reciprocal"};
quotes are needed (default \code{"identity"}).}

\item{m_binomial}{a vector of binomial trials having \code{length(y)}. Default is 1 vector for \code{family = "binomial"}, NULL otherwise.}

\item{wts}{the weight vector of \code{length(y)}. Default is 1.}

\item{r_gamma}{a vector of gamma shape parameters. Default is 1 vector for for \code{family = "Gamma"}, NULL otherwise.}

\item{int}{set to TRUE or FALSE to include intercept term in linear predictor (default \code{TRUE}).}

\item{se_pred}{a scalar, e.g. \code{se = 2} (default) to produce twice se surfaces,
set \code{se} > 0. Used for CIs at \code{XYpred} locations.}
}
\value{
\item{pcoef}{a vector of length \code{(Pars[1,3]+Pars[1,4])*(Pars[2,3]+Pars[2,4])}
of (unfolded) estimated P-spline coefficients for tensor surface.}
\item{summary_predicted}{inverse link prediction vectors, and standard error surfaces.}
\item{dev}{deviance of fit.}
\item{eff_df}{the approximate effective dimension of fit.}
\item{aic}{AIC.}
\item{df_resid}{approximate df residual.}
\item{cv}{leave-one-out standard error prediction, when \code{family = "gaussian"}.}
\item{cv_predicted}{standard error prediction for \code{y_predict}, when \code{family = "gaussian"}.}
\item{avediff_pred}{mean absolute difference prediction, when \code{family = 'gaussian'}.}
\item{Pars}{design and tuning parameters (see above arguments).}
\item{Dispersion_parm}{estimate of dispersion, \code{dev/df_resid}.}
\item{summary_predicted}{inverse link prediction vectors at \code{M_pred}, and standard error bands.}
\item{eta_predicted}{estimated linear predictor of \code{length(y)}.}
\item{press_mu}{leave-one-out prediction of mean, when \code{family = "gaussian"}.}
\item{bin_percent_correct}{percent correct classification based on 0.5 cut-off,
when \code{family = "binomial"}, NULL otherwise.}
\item{B}{Tensor basis (\code{p1} x \code{p2}) by (\code{n1} x \code{n2}) for 2D signal regression.}
\item{Q}{Effective regressors (\code{m} by \code{n1} * \code{n2}) for 2D signal regression.}
\item{Ahat}{smooth P-spline coefficient vector of length \code{p1} x \code{p2},
constructed by \code{B} \%*\% \code{pcoef}.}
\item{M}{the signal/image regressors.}
\item{y}{the response vector.}
\item{M1index}{index of length \code{p1} for rows of regressor matrix.}
\item{M2index}{index of length \code{p2} for columns of regressor matrix.}
\item{M_type}{"stacked" or "unfolded".}
\item{w}{GLM weight vector of length \code{m}.}
\item{h}{"hat" diagonals.}
\item{ridge_adj}{additional ridge tuning parameter to stabilize estimation.}
}
\description{
\code{ps2DSignal} is a function used to regress a (glm) response onto a two-dimensional
signal or image, with aniosotripic penalization of tensor product P-splines.
}
\details{
Support functions needed: \code{pspline_fitter}, \code{bbase}, and \code{pspline_2dchecker}.
}
\examples{
library(fields)
library(JOPS)

# Get the data
x0 <- Sugar$X
x0 <- x0 - apply(x0, 1, mean) # center Signal
y <- as.vector(Sugar$y[, 3]) # Response is Ash

# Inputs for two-dimensional signal regression
nseg <- c(7, 37)
pord <- c(3, 3)
min_ <- c(230, 275)
max_ <- c(340, 560)
M1_index <- rev(c(340, 325, 305, 290, 255, 240, 230))
M2_index <- seq(from = 275, to = 560, by = .5)
p1 <- length(M1_index)
p2 <- length(M2_index)

# Fit optimal model based on LOOCV
opt_lam <- c(8858.6679, 428.1332) # Found via svcm
Pars_opt <- rbind(
  c(min_[1], max_[1], nseg[1], 3, opt_lam[1], pord[1]),
  c(min_[2], max_[2], nseg[2], 3, opt_lam[2], pord[2])
)
fit <- ps2DSignal(y, x0, p1, p2, "unfolded", M1_index, M2_index,
  Pars_opt,int = TRUE, ridge_adj = 0.0001,
  M_pred = x0 )

# Plotting coefficient image
 plot(fit)
}
\references{
Marx, B.D. and Eilers, P.H.C. (2005).
Multidimensional penalized signal regression, \emph{Technometrics}, 47: 13-22.

Eilers, P.H.C. and Marx, B.D. (2021). \emph{Practical Smoothing, The Joys of
P-splines.} Cambridge University Press.
}
\author{
Paul Eilers and Brian Marx
}
