% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{lm2}
\alias{lm2}
\title{Modified lm() to use a specified design matrix}
\usage{
lm2(
  formula,
  data,
  subset,
  weights,
  na.action,
  method = "qr",
  model = TRUE,
  x = FALSE,
  y = FALSE,
  qr = TRUE,
  singular.ok = TRUE,
  contrasts = NULL,
  offset,
  designMatrix,
  yObserved,
  ...
)
}
\arguments{
\item{formula}{An object of class "formula" although it is only minimally used}

\item{data}{the dataset}

\item{subset}{subset}

\item{weights}{any weights}

\item{na.action}{Defaults to \code{na.omit}}

\item{method}{defaults to \dQuote{qr}}

\item{model}{defaults to \code{TRUE}}

\item{x}{defaults to \code{FALSE}}

\item{y}{defaults to \code{FALSE}}

\item{qr}{defaults to \code{TRUE}}

\item{singular.ok}{defaults to \code{TRUE}}

\item{contrasts}{defaults to \code{NULL}}

\item{offset}{missing by default}

\item{designMatrix}{a model matrix / design matrix (all numeric, pre coded if applicable for discrete variables)}

\item{yObserved}{the observed y values}

\item{...}{additional arguments}
}
\value{
an lm class object
}
\description{
This function is a minor modification of the lm() function
to allow the use of a pre-specified design matrix. It is not intended for
public use but only to support \code{modelTest.lm}.
}
\examples{
mtcars$cyl <- factor(mtcars$cyl)
m <- lm(mpg ~ hp * cyl, data = mtcars)

x <- model.matrix(m)
y <- mtcars$mpg
m2 <- JWileymisc:::lm2(mpg ~ 1 + cyl + hp:cyl, data = mtcars,
  designMatrix = x[, -2, drop = FALSE],
  yObserved = y)

anova(m, m2)

rm(m, m2, x, y)
}
\seealso{
\code{lm}
}
