/*
 * Decompiled with CFR 0.152.
 */
package org.omegahat.Environment.Interpreter;

import antlr.NoViableAltException;
import antlr.ParserException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.util.zip.ZipInputStream;
import org.omegahat.Environment.IO.InputConsumer;
import org.omegahat.Environment.IO.InputSupplier;
import org.omegahat.Environment.IO.PromptSource;
import org.omegahat.Environment.Interpreter.Evaluator;
import org.omegahat.Environment.Interpreter.EvaluatorManager;
import org.omegahat.Environment.Interpreter.Options;
import org.omegahat.Environment.Interpreter.UserClassEvaluator;
import org.omegahat.Environment.Language.Evaluable;
import org.omegahat.Environment.Language.Function;
import org.omegahat.Environment.Parser.AntlrParser.IncompleteExpression;
import org.omegahat.Environment.Parser.Parse.ExpressionInt;
import org.omegahat.Environment.Parser.Parse.FunctionExpression;
import org.omegahat.Environment.Parser.Parse.List;

public class InteractiveEvaluator
extends UserClassEvaluator
implements InputConsumer,
PromptSource {
    protected boolean notify_listeners = true;
    protected boolean continuation = false;
    protected String continuationPrompt = null;
    protected StringBuffer pendingInput = new StringBuffer(30);
    protected Evaluable promptExpression = null;
    public boolean interrupt = false;

    public InteractiveEvaluator() {
        this.promptExpression(this.options().prompt());
    }

    public InteractiveEvaluator(Evaluator evaluator) {
        super(evaluator);
        this.promptExpression(this.options().prompt());
    }

    public InteractiveEvaluator(EvaluatorManager evaluatorManager) {
        super(evaluatorManager);
        this.promptExpression(this.options().prompt());
    }

    public InteractiveEvaluator(Options options) {
        super(options);
        this.promptExpression(this.options().prompt());
    }

    public ExpressionInt currentExpression(ExpressionInt expressionInt) {
        if (this.interrupt) {
            this.interrupt = false;
            throw new RuntimeException("Interrupted");
        }
        return super.currentExpression(expressionInt);
    }

    public Object deserialize(File file) throws ClassNotFoundException, StreamCorruptedException, IOException, OptionalDataException {
        return this.deserialize(file, false);
    }

    public Object deserialize(File file, boolean bl) throws ClassNotFoundException, StreamCorruptedException, IOException, OptionalDataException {
        InputStream inputStream = new FileInputStream(file);
        if (bl) {
            inputStream = new ZipInputStream(inputStream);
        }
        return this.deserialize(inputStream);
    }

    public Object deserialize(InputStream inputStream) throws ClassNotFoundException, StreamCorruptedException, IOException, OptionalDataException {
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        Object object = this.deserialize(objectInputStream);
        objectInputStream.close();
        return object;
    }

    public Object deserialize(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException, OptionalDataException {
        return objectInputStream.readObject();
    }

    public Object deserialize(String string) throws ClassNotFoundException, StreamCorruptedException, IOException, OptionalDataException {
        return this.deserialize(string, false);
    }

    public Object deserialize(String string, boolean bl) throws ClassNotFoundException, StreamCorruptedException, IOException, OptionalDataException {
        return this.deserialize(new File(string), bl);
    }

    public Object evaluate(Object object, String string) throws Throwable {
        this.interrupt = false;
        return super.evaluate(object, string);
    }

    public boolean inputReady(String string) {
        this.continuation = false;
        try {
            ExpressionInt expressionInt;
            try {
                this.pendingInput.append(string);
                string = this.pendingInput.toString();
                expressionInt = this.parse(string);
            }
            catch (NoViableAltException noViableAltException) {
                expressionInt = this.parse(String.valueOf(string) + ";");
            }
            this.evaluate(expressionInt, string);
            this.pendingInput = new StringBuffer(30);
        }
        catch (NoViableAltException noViableAltException) {
            String string2 = noViableAltException.token.getText();
            if (string2 == null || string2.equals(";")) {
                this.continuation = true;
            } else {
                this.pendingInput = new StringBuffer(30);
                this.parserError((Exception)((Object)noViableAltException));
            }
        }
        catch (IncompleteExpression incompleteExpression) {
            this.continuation = true;
        }
        catch (ParserException parserException) {
            this.parserError((Exception)((Object)parserException));
            parserException.printStackTrace();
            this.pendingInput = new StringBuffer(30);
        }
        catch (Throwable throwable) {
            System.err.println("Error " + throwable.getClass());
            System.err.println(throwable);
            throwable.printStackTrace();
        }
        return true;
    }

    public boolean inputReady(InputSupplier inputSupplier) {
        String string = (String)inputSupplier.getInput();
        this.inputReady(string);
        return true;
    }

    public boolean interrupt() {
        if (this.currentExpression == null) {
            return false;
        }
        System.err.println("Current Expression: " + this.currentExpression);
        Thread thread = (Thread)this.get("readerThread");
        if (thread != null) {
            thread.stop(new RuntimeException("Interrupting the evaluator task."));
        }
        return this.interrupt;
    }

    public int notifyListeners(ExpressionInt expressionInt, boolean bl) {
        if (this.notify_listeners()) {
            return super.notifyListeners(expressionInt, bl);
        }
        return -1;
    }

    public boolean notify_listeners() {
        return this.notify_listeners;
    }

    public boolean notify_listeners(boolean bl) {
        this.notify_listeners = bl;
        return this.notify_listeners();
    }

    public void parserError(Exception exception) {
        if (exception instanceof ParserException) {
            ParserException parserException = (ParserException)((Object)exception);
            System.err.println("Parser error on line " + parserException.line + " column " + parserException.column);
            System.err.println("\t" + parserException.getMessage() + " ( " + ((Object)((Object)parserException)).getClass().getName() + ")");
        } else {
            System.err.println("(Unrecognized) error when parsing");
        }
    }

    public String prompt() {
        if (this.continuation) {
            if (this.continuationPrompt == null) {
                this.continuationPrompt = this.options().getProperty("continue", true);
            }
            if (this.continuationPrompt == null) {
                this.continuationPrompt = "..";
            }
            return this.continuationPrompt;
        }
        if (this.promptExpression == null) {
            return this.options().prompt();
        }
        Object object = null;
        try {
            try {
                this.notify_listeners(false);
                object = this.promptExpression.eval(this);
                if (object instanceof List) {
                    object = ((List)object).lastElement();
                }
            }
            catch (Throwable throwable) {
                System.err.println("Problem evaluating prompt");
                throwable.printStackTrace();
            }
            Object var3_3 = null;
            this.currentExpression(null);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.currentExpression(null);
            this.notify_listeners(true);
            throw throwable;
        }
        this.notify_listeners(true);
        if (object != null) {
            return object.toString();
        }
        return this.options().prompt();
    }

    public Evaluable promptExpression() {
        return this.promptExpression;
    }

    public Evaluable promptExpression(String string) {
        if (string == null || string.equals("") || !this.options.parsePrompt) {
            return null;
        }
        ExpressionInt expressionInt = null;
        try {
            expressionInt = this.parse(String.valueOf(string) + (!string.endsWith(";") ? ";" : ""));
        }
        catch (Exception exception) {
            this.warning("Failed to parse prompt expression (" + string + "), treating as literal string");
            return this.promptExpression();
        }
        return this.promptExpression(expressionInt);
    }

    public Evaluable promptExpression(Evaluable evaluable) {
        this.promptExpression = evaluable;
        if (evaluable instanceof List && ((List)evaluable).size() == 1) {
            Object object = ((List)evaluable).lastElement();
            if (object instanceof FunctionExpression) {
                try {
                    object = ((FunctionExpression)object).eval(this);
                }
                catch (Throwable throwable) {}
            }
            if (object instanceof Function) {
                this.promptExpression = (Evaluable)object;
            }
        }
        return this.promptExpression();
    }

    public ObjectOutputStream serialize(Object object, File file) throws IOException {
        return this.serialize(object, new FileOutputStream(file));
    }

    public ObjectOutputStream serialize(Object object, ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(object);
        return objectOutputStream;
    }

    public ObjectOutputStream serialize(Object object, OutputStream outputStream) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        objectOutputStream = this.serialize(object, objectOutputStream);
        return objectOutputStream;
    }

    public ObjectOutputStream serialize(Object object, String string) throws IOException {
        return this.serialize(object, new File(string));
    }
}

