% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/math_format.R
\name{math_format}
\alias{math_format}
\title{Formatting mm:ss.th times as seconds}
\usage{
math_format(x)
}
\arguments{
\item{x}{A character vector of time(s) in track format (e.g. 1:35.93, as
minutes:seconds.tenths hundreths) to be converted to seconds (95.93)}
}
\value{
returns the value of the string \code{x} which represents a time in
track format (mm:ss.th) and converts it to seconds
}
\description{
Takes a character string (or list) representing time in track format (e.g.
1:35.37) and converts it to a numeric value (95.37) or a list of values
representing seconds.
}
\examples{
math_format("1:35.93")
math_format("16:45.19")
math_format("25.43")
math_format(c("1:35.93", "16:45.19", NA, "25.43"))

}
