% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernfun.R
\name{kernfun}
\alias{kernfun}
\title{Kernel Functions}
\usage{
kernfun(type)
}
\arguments{
\item{type}{A \code{character} denoting the kernel type; 'epan'(Epanechnikov), 'unif'(Uniform), 'quar'(Quartic), 'gauss'(Gaussian).}
}
\value{
The corresponding kernel function.
}
\description{
Some common-used kernel functions.
}
\examples{
x <- seq(-2, 2, 0.01)
par(mfrow = c(2,2))
plot(x, kernfun("epan")(x), type = "l", main = "Epanechnikov")
plot(x, kernfun("unif")(x), type = "l", main = "Uniform")
plot(x, kernfun("quar")(x), type = "l", main = "Quartic")
plot(x, kernfun("gauss")(x), type = "l", main = "Gaussian")
par(mfrow = c(1,1))
}
