% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/FbKM.R
\name{FbKM}
\alias{FbKM}
\title{KM for Binary Traits in Familial GWAS Data (calculate p-value)}
\usage{
FbKM(obj, genotypes, gid, weights = NULL, acc = 1e-04,
  append.write = NULL)
}
\arguments{
\item{obj}{results saved from FbKM_Null_Model.}

\item{genotypes}{1st column: gene name; 2nd column: snp name; 3rd-end columns: A matrix of genotypes for each subject (class: data.frame). The order of 3rd-end columns should match id. Coded as 0, 1, 2 and no missing. This genotype file can be a big file containing all genes or it can be files containing one single gene.}

\item{gid}{A vector of id mapping to samples in genotype file (class: vector). So the order of samples in gid must be the same as the order in genotypes. Make sure it is not a factor. Although gid doesn't have to be in the same order as id, it is suggested to make them sorted in the same order in order to make all files easily to be tracked. No missing.}

\item{weights}{1st column: gene name; 2nd column: snp name; 3rd column: A vector with the length equal to the number of variants in the test (class: data.frame). Default is Null indicating equal weight for all markers}

\item{acc}{Accuracy of numerical integration used in Davies' method. Default 1e-4.}

\item{append.write}{The name of pvalue output file. Write out p-values in real time. Don't need to wait until all genes are processed to get the final output.}
}
\value{
output: binary trait family KM (Fb-KM) p-value
}
\description{
This function (FbKM) is used to perform the KM analysis (Yan et al., 2014) for binary traits in familial GWAS data
}
\examples{
#################################################################
### Examples for Binary Traits in Familial GWAS Data using KM ###
#################################################################
### Subject IDs are numeric ###
data("FbKM_numID")
obj1 <- FbKM_Null_Model(phenotype=fbkm_n_y$y, id=fbkm_n_y$id, fa=fbkm_n_y$fa,
mo=fbkm_n_y$mo, family="binomial", covariates=NULL)
pvalue1 <- FbKM(obj=obj1, genotypes=fbkm_n_gene, gid=fbkm_n_geneid$gid, weights=NULL,
append.write="./pvalues.out")
pvalue1 <- FbKM(obj=obj1, genotypes=fbkm_n_gene, gid=fbkm_n_geneid$gid, weights=NULL,
append.write=NULL)
obj2 <- FbKM_Null_Model(phenotype=fbkm_n_y$y, id=fbkm_n_y$id, fa=fbkm_n_y$fa,
mo=fbkm_n_y$mo, family="binomial", covariates=NULL)
pvalue2 <- FbKM(obj=obj2, genotypes=fbkm_n_gene, gid=fbkm_n_geneid$gid, weights=
fbkm_n_weights, append.write=NULL)
obj3 <- FbKM_Null_Model(phenotype=fbkm_n_y$y, id=fbkm_n_y$id, fa=fbkm_n_y$fa,
mo=fbkm_n_y$mo, family="binomial", covariates=fbkm_n_covariates)
pvalue3 <- FbKM(obj=obj3, genotypes=fbkm_n_gene, gid=fbkm_n_geneid$gid, weights=
fbkm_n_weights, append.write=NULL)
# Read in a list of genes files instead of a big file containing all genes
obj4 <- FbKM_Null_Model(phenotype=fbkm_n_y$y, id=fbkm_n_y$id, fa=fbkm_n_y$fa,
mo=fbkm_n_y$mo, family="binomial", covariates=NULL)
gene <- split(fbkm_n_gene, fbkm_n_gene[,1])
for (k in 1:2) {
  gene[[k]]$gene <- as.character(gene[[k]]$gene)
  pvalue1 <- FbKM(obj=obj4, genotypes=gene[[k]], gid=fbkm_n_geneid$gid, weights=NULL,
  append.write="./pvalues.out")
  }
### Subject IDs are character ###
data("FbKM_charID")
obj1 <- FbKM_Null_Model(phenotype=fbkm_c_y$y, id=as.character(fbkm_c_y$id),
fa=as.character(fbkm_c_y$fa), mo=as.character(fbkm_c_y$mo), family="binomial",
covariates=NULL)
pvalue1 <- FbKM(obj=obj1, genotypes=fbkm_c_gene, gid=as.character(fbkm_c_geneid$gid),
weights=NULL)
ys <- fbkm_c_y[order(fbkm_c_y$id),] #Sorted character IDs
obj1 <- FbKM_Null_Model(phenotype=ys$y, id=as.character(ys$id), fa=as.character(ys$fa),
mo=as.character(ys$mo),  covariates=NULL)
pvalue1 <- FbKM(obj=obj1, genotypes=fbkm_c_gene, gid=as.character(fbkm_c_geneid$gid),
weights=NULL)
}

