% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importance.score.R
\name{importance.score}
\alias{importance.score}
\title{Importance Score}
\usage{
importance.score(fit, Y, X)
}
\arguments{
\item{fit}{A fitted object of class xgb.Booster.}

\item{Y}{A vector of responses.}

\item{X}{An input design matrix.}
}
\value{
A list of (1) shap, a vector of Hapley Additive exPlanations for each feature;
                  (2) saabas, a vector of an individualized heuristic feature attribution method, which can be considered as an approximation for shap.
}
\description{
Generate SHAP (SHapley Additive exPlanations) and Saabas scores.
}
\examples{
set.seed(10)
X <- matrix(rnorm(100), nrow = 10)
Y <- matrix(rnorm(10), nrow = 10)
dtrain <- xgboost::xgb.DMatrix(X, label = Y)
fit.model <- xgboost::xgb.train(data = dtrain, nrounds = 5)
tmp <- importance.score(fit = fit.model, Y = Y, X = X)

}
\references{
\insertRef{candes2018panning}{KOBT}
\insertRef{chen2016xgboost}{KOBT}
\insertRef{lundberg2017unified}{KOBT}
}
