% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Scale.R
\name{Scale}
\alias{Scale}
\title{Scale a vector}
\usage{
Scale(x, expected_M = NULL, expected_SD = NULL, oadvances = NULL)
}
\arguments{
\item{x}{The original vector.}

\item{expected_M}{The expected Mean of the scaled vector.}

\item{expected_SD}{The expected Standard Deviation (unit) of the scaled vector.}

\item{oadvances}{The distance the Origin of x advances by.}
}
\value{
The scaled vector.
}
\description{
Scale a vector
}
\details{
To scale \code{x}, its origin, or unit (\emph{expected_SD}), or both, could be changed.

If \code{expected_M} = 0 or \code{NULL}, and \code{expected_SD} = \code{NULL}, \code{x} would be mean-centered.

If \code{expected_M} is a non-zero number, and \code{expected_SD} = \code{NULL}, the mean of \code{x} would be transformed to expected_M.

If \code{expected_M} = 0 or \code{NULL}, and \code{expected_SD} = 1, \code{x} would be standardized to be its z-score with \emph{M} = 0 and \emph{SD} = 1.

The standardized score is not necessarily the z-score. If neither \code{expected_M} nor \code{expected_SD} is \code{NULL},
\code{x} would be standardized to be a vector whose mean and standard deviation would be \code{expected_M} and \code{expected_SD}, respectively.
To standardize \code{x}, the mean and standard deviation of \code{x} are needed and computed,
for which the missing values of \code{x} are removed if any.

If \code{oadvances} is not \code{NULL},  the origin of \code{x} will advance with the standard deviation being unchanged.
In this case, \code{Scale()} could be used to pick points in simple slope analysis for moderation models.
Note that when \code{oadvances} is not \code{NULL}, \code{expected_M} and \code{expected_SD} must be NULL.
}
\examples{
(x <- rnorm(10, 5, 2))
# Mean-center x.
Scale(x)
# Transform the mean of x to 3.
Scale(x, expected_M = 3)
# Transform x to its z-score.
Scale(x, expected_SD = 1)
# Standardize x with *M* = 100 and *SD* = 15.
Scale(x, expected_M = 100, expected_SD = 15)
# The origin of x advances by 3.
Scale(x, oadvances = 3)
}
