% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_lm.R
\name{compare_lm}
\alias{compare_lm}
\title{Compare lm()'s fitted outputs using PRE and R-squared.}
\usage{
compare_lm(
  fitC = NULL,
  fitA = NULL,
  n = NULL,
  PC = NULL,
  PA = NULL,
  SSEC = NULL,
  SSEA = NULL
)
}
\arguments{
\item{fitC}{The result of \code{lm()} of the Compact model (Model C).}

\item{fitA}{The result of \code{lm()} of the Augmented model (Model A).}

\item{n}{Sample size of the Model C or Model A. Model C and Model A must use the same sample, and hence have the same sample size.}

\item{PC}{The number of parameters in Model C.}

\item{PA}{The number of parameters in Model A. PA must be larger than PC.}

\item{SSEC}{The Sum of Squared Errors (SSE) of Model C.}

\item{SSEA}{The Sum of Squared Errors of Model A.}
}
\value{
A data.frame with 3 rows and 8 columns. The first row reports information for Model C, the second for Model A, and the third for the change. The data.frame presents \emph{SSE}, \emph{df} of \emph{SSE}, \emph{PRE}, the \emph{F}-test of \emph{PRE} (\emph{F}, \emph{p}), and \emph{PRE_adjusted}. If fitC and fitA are not inferior to the intercept-only model, R-squared and Adjusted R-squared will also be computed.
}
\description{
Compare lm()'s fitted outputs using PRE and R-squared.
}
\details{
\code{compare_lm()} compare Model A with Model C using \emph{PRE} (Proportional Reduction in Error) and R-squared. \emph{PRE} is partial R-squared (called partial Eta-squared in Anova).There are two ways of using \code{compare_lm()}. The first is giving \code{compare_lm()} fitC and fitA. The second is giving \emph{n}, \emph{PC}, \emph{PA}, \emph{SSEC}, and \emph{SSEA}. The first way is more convenient, and it minimizes precision loss by omitting copying-and-pasting. If fitC and fitA are not inferior to the intercept-only model, R-squared and Adjusted R-squared are also computed. Note that the \emph{F}-tests for \emph{PRE} and R-squared change are equivalent. Please refer to Judd et al. (2017) for more details about \emph{PRE}.
}
\examples{
x1 <- rnorm(193)
x2 <- rnorm(193)
y <- 0.3 + 0.2*x1 + 0.1*x2 + rnorm(193)
dat <- data.frame(y, x1, x2)
# Fix intercept to constant 1 using I().
fit1 <- lm(I(y - 1) ~ 0, dat)
# Free intercept.
fit2 <- lm(y ~ 1, dat)
compare_lm(fit1, fit2)
# One predictor.
fit3 <- lm(y ~ x1, dat)
compare_lm(fit2, fit3)
# Fix intercept to 0.3 using offset().
intercept <- rep(0.3, 193)
fit4 <- lm(y ~ 0 + x1 + offset(intercept), dat)
compare_lm(fit4, fit3)
# Two predictors.
fit5 <- lm(y ~ x1 + x2, dat)
compare_lm(fit2, fit5)
compare_lm(fit3, fit5)
# Fix slope of x2 to 0.05 using offset().
fit6 <- lm(y ~ x1 + offset(0.05*x2), dat)
compare_lm(fit6, fit5)
}
\references{
Judd, C. M., McClelland, G. H., & Ryan, C. S. (2017). \emph{Data analysis: A model comparison approach to regression, ANOVA, and beyond}. Routledge.
}
