% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_matrix.R
\name{kernel_matrix}
\alias{kernel_matrix}
\title{Kernel Matrix Computation}
\usage{
kernel_matrix(
  x,
  y = x,
  kernel = c("gauss", "hermite"),
  sigma = 1,
  hermite_rank = 3
)
}
\arguments{
\item{x}{Numeric vector.}

\item{y}{Numeric vector, default is \code{x}.}

\item{kernel}{Either \code{"gauss"} or \code{"hermite"}.}

\item{sigma}{Numeric value of the kernel variance. Default is 1.}

\item{hermite_rank}{Rank of the Hermite kernel. Default is 3. Ignored, when the Gaussian kernel is chosen.}
}
\value{
A numeric kernel matrix.
}
\description{
Computes kernel matrices for Gaussian and Hermite kernels.
}
\details{
The function computes a matrix in the form of \eqn{(K_{ij})_{(i,j)} = K(x_i, x_j)} or \eqn{(K_{ij})_{(i,j)} = K(x_i, y_j)} 
for a kernel function \eqn{K} depending if a second vector was given. The following two kernels are offered:
\itemize{
\item Gaussian Kernel: \eqn{K(x, y) = e^{(x-y)^2 / 2 \sigma^2}}
\item Hermite Kernel: \eqn{K(x, y) = \sum_{k=0}^d e^{-x^2 / 2 \sigma^2} e^{-y^2 / 2 \sigma^2} \frac{h_k(x / \sigma) h_k(y / \sigma)}{2^k k!}}
where \eqn{h_k} is the Hermite polynomial of grade \eqn{k}
}
}
\examples{
x <- rnorm(10)
kernel_matrix(x, kernel = "gauss", sigma = 4)
kernel_matrix(x, kernel = "hermite", sigma = 4, hermite_rank = 3)
}
\author{
Christoph L. Koesner
}
