% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{dbivr}
\alias{dbivr}
\title{Bivariate kernel density estimation for rounded data}
\usage{
dbivr(xrounded, roundvalue, burnin = 2, samples = 5,
  adaptive = FALSE, gridsize = 200)
}
\arguments{
\item{xrounded}{rounded values from which to estimate bivariate density, matrix with 2 columns (x,y)}

\item{roundvalue}{rounding value (side length of square in that the true value lies around the rounded one)}

\item{burnin}{burn-in sample size}

\item{samples}{sampling iteration size}

\item{adaptive}{set to TRUE for adaptive bandwidth}

\item{gridsize}{number of evaluation grid points}
}
\value{
The function returns a list object with the following objects (besides all input objects):
\item{\code{Mestimates}}{kde object containing the corrected density estimate}
\item{\code{gridx}}{Vector Grid on which density is evaluated (x)}
\item{\code{gridy}}{Vector Grid on which density is evaluated (y)}
\item{\code{resultDensity}}{Array with Estimated Density for each iteration}
\item{\code{resultX}}{Matrix of true latent values X estimates}
\item{\code{delaigle}}{Matrix of Delaigle estimator estimates}
}
\description{
Bivariate kernel density estimation for rounded data
}
\examples{
# Create Mu and Sigma  -----------------------------------------------------------
mu1 <- c(0, 0)
mu2 <- c(5, 3)
mu3 <- c(-4, 1)
Sigma1 <- matrix(c(4, 3, 3, 4), 2, 2)
Sigma2 <- matrix(c(3, 0.5, 0.5, 1), 2, 2)
Sigma3 <- matrix(c(5, 4, 4, 6), 2, 2)
# Mixed Normal Distribution -------------------------------------------------------
mus <- rbind(mu1, mu2, mu3)
Sigmas <- rbind(Sigma1, Sigma2, Sigma3)
props <- c(1/3, 1/3, 1/3)
\dontrun{xtrue=rmvnorm.mixt(n=1000, mus=mus, Sigmas=Sigmas, props=props)
roundvalue=2
xrounded=plyr::round_any(xtrue,roundvalue)
est <- dbivr(xrounded,roundvalue=roundvalue,burnin=5,samples=10)

#Plot corrected and Naive distribution
plot(est,trueX=xtrue)
#for comparison: plot true density
 dens=dmvnorm.mixt(x=expand.grid(est$Mestimates$eval.points[[1]],est$Mestimates$eval.points[[2]]),
  mus=mus, Sigmas=Sigmas, props=props)
 dens=matrix(dens,nrow=length(est$gridx),ncol=length(est$gridy))
 contour(dens,x=est$Mestimates$eval.points[[1]],y=est$Mestimates$eval.points[[2]],
    xlim=c(min(est$gridx),max(est$gridx)),ylim=c(min(est$gridy),max(est$gridy)),main="True Density")}
}
