% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RevisedMdeFunc.R
\name{KoulArMde}
\alias{KoulArMde}
\title{Minimum distance estimation in the autoregression model of the known order.}
\usage{
KoulArMde(X, AR_Order, IntMeasure)
}
\arguments{
\item{X}{- Vector of \code{n} observed values.}

\item{AR_Order}{- Order of the autoregression model.}

\item{IntMeasure}{- Symmetric and \eqn{\sigma}-finite measure.}
}
\value{
rhohat - Minimum distance estimator of \eqn{\rho}.

residual - Residuals after minimum distance estimation.
}
\description{
Estimates the autoressive coefficients in the \eqn{X_t = \rho' Z_t + \xi_t } where \eqn{Z_t} is the vector of \eqn{q} observations at times \eqn{t-1,...,t-q}.
}
\examples{
##### Generate stationary AR(2) process with 10 observations
n <- 10
q <- 2
rho <- c(-0.2, 0.8)    ##### Generate true parameters rho = (-0.2, 0.8)'
eps <- rnorm(n, 0,1)   ##### Generate innovations from N(0,1)
X <- rep(0, times=n)
for (i in 1:n){
 tempCol <- rep(0, times=q)
 for (j in 1:q){
   if(i-j<=0){
     tempCol[j] <- 0
   }else{
     tempCol[j] <- X[i-j]
   }
 }
X[i] <- t(tempCol)\%*\% rho + eps[i]
}

Lx <- "Lebesgue"                               ##### Define Lebesgue measure
MDEResult <- KoulArMde(X, q, Lx)               ##### Use Lebesgue measure for the integration
rhohat <- MDEResult$rhohat                     ##### Obtain minimum distance estimator
resid  <- MDEResult$residual                   ##### Obtain residual

Dx <- "Degenerate"                             ##### Define degenerate measure at 0
MDEResult <- KoulArMde(X, q, Dx)               ##### Use degenerate measure for the integration
rhohat <- MDEResult$rhohat                     ##### Obtain minimum distance estimator
resid <- MDEResult$residual                    ##### Obtain residual
}
\references{
[1] Koul, H. L (1985). Minimum distance estimation in linear regression with unknown error distributions. Statist. Probab. Lett., 3 1-8.

[2] Koul, H. L (1986). Minimum distance estimation and goodness-of-fit tests in first-order autoregression. Ann. Statist., 14 1194-1213.

[3] Koul, H. L (2002). Weighted empirical process in nonlinear dynamic models. Springer, Berlin, Vol. 166
}
\seealso{
KoulLrMde() and Koul2StageMde()
}

