% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.R
\name{lagosne_load}
\alias{lagosne_load}
\title{Load LAGOSNE data}
\usage{
lagosne_load(version, format = "rds", fpath = NA)
}
\arguments{
\item{version}{character LAGOSNE database version string}

\item{format}{character choice of rds or sqlite}

\item{fpath}{file.path optionally specify custom location of LAGOSNE rds file}
}
\description{
Load LAGOSNE data from local system files
}
\examples{
\dontrun{
dt  <- lagosne_load("1.054.1")
dt2 <- lagosne_load("1.054.2")

compare_columns <- function(num){
 identical(dt2$epi_nutr[,num], dt$epi_nutr[,num])
}
names(dt2$epi_nutr)[sapply(13:94, compare_columns)]

}
}
