\name{BEAPFrOG}
\alias{ BEAPFrOG }
\title{Bayesian Estimation of Admixture in Parental From Offspring Genotype}
\description{Provides estimates of admixture proportions in offspring and ungenotyped parents, using genotype data}
\usage{
BEAPFrOG(data,p,nchains=1,iterations=1000,alpha=0.05,prior=1,burn=2000,SampSizes)
}
\arguments{
\item{data}{Vector of  allele counts: each element either 0,1,2 or NA. }
\item{p}{Matrix of allele frequencies. Each row corresponds with a SNP. Number of rows must equal length of data. Each column is a population }
\item{nchains}{Number of Markov Chains to perform gibbs sampling}
\item{iterations}{Number of samples for each Markov Chain}
\item{alpha}{1 minus the width of credible interval taken around the posterior mode.}
\item{prior}{Concentration parameter for the dirichlet distribution. 1 is uninformative, small values suggest first-generation admixture (uninformative as to which source populations involved), and higher values suggest low parental divergence.}
\item{burn}{Burn- in period. The number of MCMC samples to discard.} 
\item{SampSizes}{Vector of the same length as the number of source populations. Each element is the number of individuals used to calculate allele frequencies in that population. Parameterises the prior on allele frequencies } 
}
\value{
A  list including elements
\item{P1est}{ A vector: Posterior mode for admixture proportions in parent 'A'.}
\item{P2}{ A vector: Posterior mode for admixture proportions in parent 'B'.}
\item{P1i}{ A matrix of two columns and number of rows equal to number of populations: upper and lower credible intervals of width defined by the argument alpha, for admixture proportions in parent 'A'.}
\item{P2i}{ A matrix of two columns and number of rows equal to number of populations: upper and lower credible intervals of width defined by the argument alpha, for admixture proportions in parent 'B'.}
\item{Monitor}{All stored MCMC samples. Use plot() on this object for visualisation of posterior distribution and MCMC trace }
}
\details{
BEAPFrOG requires jags and rjags to be installed. http://mcmc-jags.sourceforge.net/
Credible intervals are centered around the mode.

Values for parameter vectors m1 and m2 can be exchanged to give identical likelihoods. This may give rise to bimodal posterior distributions, particularly with first-generation admixture, and the resulting credible intervals are not useful. Therefore, for all MCMC samples, we  redefine m1 as the admixture proportions for the parent with admixture from population 1 less than 0.5, and vice-versa for m2.  
}
\author{Daniel Crouch & Michael Weale, Department of Medical and Molecular Genetics, King's College London}
\seealso{\code{\link[LEAPFrOG:LEAPFrOG]{LEAPFrOG}},\code{\link[LEAPFrOG:LEAPFrOG_plot]{LEAPFrOG_plot}}
}
