% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LEGIT.R
\name{example_2way_lme4}
\alias{example_2way_lme4}
\title{Simulated example of a 3 way interaction GxExZ model}
\usage{
example_2way_lme4(N, sigma = 1, logit = FALSE, seed = NULL)
}
\arguments{
\item{N}{Sample size.}

\item{sigma}{Standard deviation of the gaussian noise (if \code{logit}=FALSE).}

\item{logit}{If TRUE, the outcome is transformed to binary with a logit link.}

\item{seed}{RNG seed.}
}
\value{
Returns a list containing, in the following order: data.frame with the observed outcome (with noise) and the true outcome (without noise), list containing the data.frame of the genetic variants (G), the data.frame of the \eqn{e} environments (E) and the data.frame of the \eqn{z} environments (Z), vector of the true genetic coefficients, vector of the true \eqn{e} environmental coefficients, vector of the true \eqn{z} environmental coefficients, vector of the true main model coefficients
}
\description{
Simulated example of a 3 way interaction GxExZ model (where G, E and Z are latent variables). 
\deqn{g_j \sim Binomial(n=1,p=.30)}
\deqn{j = 1, 2, 3, 4}
\deqn{e_k \sim Normal(\mu=0,\sigma=1.5)}
\deqn{k = 1, 2, 3}
\deqn{z_l \sim Normal(\mu=3,\sigma=1)}
\deqn{l = 1, 2, 3}
\deqn{g = .2g_1 + .15g_2 - .3g_3 + .1g_4 + .05g_1g_3 + .2g_2g_3}
\deqn{e = -.45e_1 + .35e_2 + .2e_3}
\deqn{z = .15z_1 + .60z_2 + .25z_3}
\deqn{\mu = -2 + 2g + 3e + z + 5ge - 1.5ez + 2gz + 2gez}
\tabular{cc}{
\eqn{y \sim Normal(\mu=\mu,\sigma=\code{sigma})} if \code{logit}=FALSE \cr
\eqn{y \sim Binomial(n=1,p=logit(\mu))} if \code{logit}=TRUE
}
}
\examples{
# Doing only one iteration so its faster
train = example_2way_lme4(250, 1, seed=777)
D = train$data
G = train$G
E = train$E

F = y ~ G*E
fit = LEGIT(D, G, E, F, lme4=FALSE, maxiter=1)
summary(fit)
F = y ~ 1
fit_test = GxE_interaction_test(D, G, E, F, criterion="AIC", lme4=FALSE, maxiter=1)
fit_test
#fit_test = GxE_interaction_test(D, G, E, F, criterion="cv", lme4=FALSE, maxiter=1, cv_iter=1)
#fit_test

F = y ~ G*E + (1|subject)
fit = LEGIT(D, G, E, F, lme4=TRUE, maxiter=1)
summary(fit)
F = y ~ (1|subject)
fit_test = GxE_interaction_test(D, G, E, F, criterion="AIC", lme4=TRUE, maxiter=1)
fit_test
#fit_test = GxE_interaction_test(D, G, E, F, criterion="cv", lme4=TRUE, maxiter=1, cv_iter=1)
#fit_test
}
