% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exchange.R
\name{exchange}
\alias{exchange}
\title{Exchange two random elements}
\usage{
exchange(X, j)
}
\arguments{
\item{X}{A Matrix.}

\item{j}{A positive integer.}
}
\value{
If all inputs are logical, then the output will be a new design matrix after the exchange.
}
\description{
\code{exchange} returns a new design matrix after two randomly selected elements are switched from a user-defined column.
}
\details{
\itemize{
\item \code{X} stands for the design matrix.
\item \code{j} is the j^th column of the design matrix, and it should be in [1,ncol(X)].
}
}
\examples{
#create a toy LHD with 5 rows and 3 columns
toy=rLHD(n=5,k=3);toy

#Choose the first column of toy and exchange two randomly selected elements.
toy_new=exchange(X=toy,j=1)
toy;toy_new
}
