% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MWT.R
\name{MWT}
\alias{MWT}
\title{Modified Williams Transformation}
\usage{
MWT(X)
}
\arguments{
\item{X}{A matrix object. In general, \code{X} stands for the design matrix, e.g. an LHD or a GLP design.}
}
\value{
If all inputs are logical, then the output will be a matrix whose sizes are the same as input matrix. Note that the output matrix is not an LHD.
}
\description{
\code{MWT} returns a matrix after implementing the modified Williams transformation
}
\examples{
#create a toy LHD with 5 rows and 3 columns
toy=rLHD(n=5,k=3);toy

#Implementing the modified Williams transformation on toy:
MWT(toy)

}
\references{
Wang, L., Xiao, Q., and Xu, H. (2018)  Optimal maximin $L_{1}$-distance Latin hypercube designs based on good lattice point designs. \emph{The Annals of Statistics}, \strong{46}(6B), 3741-3766.
}
