% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/AQSysCurve.R
\name{AQSysCurve}
\alias{AQSysCurve}
\title{This functions plot a curve based in the chosen model and its parameters.}
\usage{
AQSysCurve(mathDesc, param, xlbl = "", ylbl = "", main = NULL,
  col = "black", type = "p", cex = 1, cexlab = 1, cexaxis = 1,
  cexmain = 1, cexsub = 1, xmax = 0.4, mpl = FALSE, HR = FALSE,
  NP = 100)
}
\arguments{
\item{mathDesc}{- Equation to be used: merchuk, murugesan [type:string]}

\item{param}{- Model's parameters [type::data.frame]}

\item{xlbl}{- Plot's Horizontal axis label.}

\item{ylbl}{- Plot's Vertical axis label.}

\item{main}{- Legacy from plot package. For more details, see \code{\link{plot.default}}}

\item{col}{- Legacy from plot package. For more details, see \code{\link{plot.default}}}

\item{type}{- Legacy from plot package. For more details, see \code{\link{plot.default}}}

\item{cex}{- Legacy from plot package. For more details, see \code{\link{plot.default}}}

\item{cexlab}{- Legacy from plot package. For more details, see \code{\link{plot.default}}}

\item{cexaxis}{- Legacy from plot package. For more details, see \code{\link{plot.default}}}

\item{cexmain}{- Legacy from plot package. For more details, see \code{\link{plot.default}}}

\item{cexsub}{- Legacy from plot package. For more details, see \code{\link{plot.default}}}

\item{xmax}{- Maximum value for the Horizontal axis' value (bottom-rich component)  [type:double]}

\item{mpl}{- Multiples curves overlayed in a single plot. Default is FALSE. [type::LOGIC]}

\item{HR}{- Magnify Plot's text to be compatible with High Resolution size [type:Boulean]}

\item{NP}{- Number of points used to build the fitted curve. Default is 100. [type:Integer]}
}
\value{
A plot using the input model within the chosen interval and the curve's raw XY data.
If no interval is selected, xmax = 0.4.
}
\description{
The function returns a plot after using the parameters and model given by the user.
}
\details{
The function owns predefined set of equations that can be seen below and must be used, with adequated parameters,
to return a plot which represent the chosen model.
}
\examples{
\dontrun{
AQSysCurve("murugesan", as.data.frame(c(0.90, -3.48, 2.92)), mpl = TRUE, col = "red")
}
}

