% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structure.R
\name{IND}
\alias{IND}
\title{Independence Structure}
\usage{
IND(formula, var.time, ...)
}
\arguments{
\item{formula}{formula indicating factors influencing the residual variance.}

\item{var.time}{[character] name of the time variable.}

\item{...}{not used.}
}
\value{
An object of class \code{IND} that can be passed to the argument \code{structure} of the \code{lmm} function.
}
\description{
Variance-covariance structure where the residuals are independent.
}
\details{
A typical formula would be either \code{~1} indicating constant variance
or \code{~time} indicating a time dependent variance.
}
\examples{
IND(~1)
IND(~time)
IND(~time+gender)
IND(~time+gender,var.time="time")
IND(gender~time,var.time="time")

}
