% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleRem.R
\name{sampleRem}
\alias{sampleRem}
\title{Sample Longuitudinal Data}
\usage{
sampleRem(
  n,
  n.times,
  mu = 1:n.times,
  sigma = rep(1, n.times),
  lambda = rep(1, n.times),
  beta = c(2, 1, 0, 0, 0, 1, 1, 0, 0, 0),
  gamma = matrix(0, nrow = n.times, ncol = 10),
  format = "wide",
  latent = FALSE
)
}
\arguments{
\item{n}{[integer,>0] sample size}

\item{n.times}{[integer,>0] number of visits (i.e. measurements per individual).}

\item{mu}{[numeric vector] expected measurement value at each visit (when all covariates are fixed to 0). Must have length \code{n.times}.}

\item{sigma}{[numeric vector,>0] standard error of the measurements at each visit (when all covariates are fixed to 0). Must have length \code{n.times}.}

\item{lambda}{[numeric vector] covariance between the measurement at each visit and the individual latent variable. Must have length \code{n.times}.}

\item{beta}{[numeric vector of length 10] regression coefficient between the covariates and the latent variable.}

\item{gamma}{[numeric matrix with n.times rows and 10 columns] regression coefficient specific to each timepoint (i.e. interaction with time).}

\item{format}{[character] Return the data in the wide format (\code{"wide"}) or long format (\code{"long"})}

\item{latent}{[logical] Should the latent variable be output?}
}
\value{
a data.frame
}
\description{
Sample longuitudinal data with covariates
}
\details{
The generative model is a latent variable model where each outcome (\eqn{Y_j}) load on the latent variable (\eqn{\eta}) with a coefficient lambda:
\deqn{Y_j = \mu_j + \lambda_j*\eta + \sigma_j\epsilon_j}
The latent variable is related to the covariates (\eqn{X_1,\ldots,X_(10)}):
\deqn{\eta = \alpha + \beta_1 X_1 + ... + \beta_{10} X_{10} + \xi}
\eqn{\epsilon_j} and \eqn{\xi} are independent random variables with standard normal distribution.
}
\examples{
set.seed(10)
dW <- sampleRem(100, n.times = 3, format = "wide")
set.seed(10)
dL <- sampleRem(100, n.times = 3, format = "long")
}
