% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{list2mniw}
\alias{list2mniw}
\title{Convert list of MNIW parameter lists to vectorized format.}
\usage{
list2mniw(x)
}
\arguments{
\item{x}{List of \code{n} MNIW parameter lists.}
}
\value{
A list with the following elements:
\describe{
\item{\code{Lambda}}{The mean matrices as an array of size \verb{p x p x n}.}
\item{\code{Omega}}{The between-row precision matrices, as an array of size \verb{p x p x }.}
\item{\code{Psi}}{The between-column scale matrices, as an array of size \verb{q x q x n}.}
\item{\code{nu}}{The degrees-of-freedom parameters, as a vector of length \code{n}.}
}
}
\description{
Converts a list of return values of multiple calls to \code{\link[=lmn_prior]{lmn_prior()}} or \code{\link[=lmn_post]{lmn_post()}} to a single list of MNIW parameters, which can then serve as vectorized arguments to the functions in \pkg{mniw}.
}
