% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qBrIII.R
\name{qBrIII}
\alias{qBrIII}
\title{Quantile distribution function of BrIII distribution}
\usage{
qBrIII(u = NULL, RP = 1/(1 - u), para)
}
\arguments{
\item{u}{non-exceedance probability}

\item{RP}{Return Period "don't use in case u is used"}

\item{para}{parameters as c(scale, shape1, shape2)}
}
\value{
Quantile value/s using the inverse of the cumulative distribution function.
}
\description{
Quantile distribution function of BrIII distribution
}
\examples{

x <- qBrIII(u = 0.99, para = c(1, 10, 0.8))
x <- qBrIII(RP = 100, para = c(1, 10, 0.8))

}
\author{
Mohanad Zaghloul [aut, cre], Simon Michael Papalexiou [aut, ths], Amin Elshorbagy [aut, ths]
}
