% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/07_08_PCAs.R
\name{PCAs4clust}
\alias{PCAs4clust}
\title{PCAs4clust}
\usage{
PCAs4clust(obj2process = NULL, cumul_var_threshold = 0.9,
  filename = "", ...)
}
\arguments{
\item{obj2process}{Raster* object (or its file name). Each layer is one variable}

\item{cumul_var_threshold}{Numeric. Optional (default = 0.9). Threshold of cumulative variance
to select the number of useful PCs}

\item{filename}{Character. Output filename. Optional}

\item{...}{Optional. Arguments for \code{\link[stats]{prcomp}}}
}
\value{
RasterBrick object
}
\description{
PCAs4clust runs a two-steps process to prepare the data to be clustered
}
\details{
Firstly, a Principal Component Analysis ('screening PCA') with all the variables in
'obj2process' is run in order to know the optimal number of variables to be used in a subsequent
PCA, as well as the most associated variable to those Principal Components (PCs). A threshold
of cumulative variance (cumul_var_threshold; default = 0.9) is needed. Secondly, a 'final PCA'
is run with the results of the 'screening PCA' (i.e. number of PC axes and their most associated
variables). PCAs4clust uses \code{\link[stats]{prcomp}} to run PCAs
}
\examples{
\donttest{
dirctry <- paste0(system.file(package='LPDynR'), "/extdata")
variables_noCor <- rm_multicol(dir2process = dirctry,
                               multicol_cutoff = 0.7)
PCAs4clust(obj2process = variables_noCor,
            cumul_var_threshold = 0.9)
}

}
\seealso{
\code{\link{rm_multicol}}; \code{\link[stats]{prcomp}}
}
\author{
Xavier Rotllan-Puig
}
