% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findC.R
\name{findC}
\alias{findC}
\title{Finding best C}
\usage{
findC(timepoints, max.lag = NULL, pi = 0.95, iter = 10)
}
\arguments{
\item{timepoints}{a vector of timepoints used in the dataset}

\item{max.lag}{a numeric value with maximum lags allowed,
if null, defaults to the floor of the number of timepoints divided by 4}

\item{pi}{a numeric value between 0.5 and 1 for the upper bound on the penalty}

\item{iter}{a numeric value with the number of penalties to test}
}
\value{
a vector of length iter of the different values of C to test
}
\description{
This function computes the values of C to test using the timepoints and max lag in the dataset
}
\examples{
findC(c(0, 5, 10, 15, 20, 25), max.lag = 1, iter = 15)
findC(c(2, 4, 8, 16, 32, 64, 128, 256), iter = 5)
findC(c(2, 6, 10, 15, 22, 30, 40, 55, 80), pi = 0.8, iter = 20)
findC(c(1, 2, 3.2, 4, 5.3, 7), pi = 0.99)

}
\author{
Thevaa Chandereng, Anthony Gitter
}
