% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_tests.R
\name{beta_shape2_one_way}
\alias{beta_shape2_one_way}
\title{Test equality of shape 2s of beta distributions.}
\source{
\itemize{
\item \url{https://en.wikipedia.org/wiki/Likelihood-ratio_test}
\item Yudi Pawitan. In All Likelihood. Oxford University Press.
\item Hodd, McKean, and Craig. Introduction to Mathematical Statistics. Pearson.
}
}
\usage{
beta_shape2_one_way(x, fctr, conf.level = 0.95)
}
\arguments{
\item{x}{a numeric vector of at least 50 data values per group.}

\item{fctr}{a factor vector indicating groups.}

\item{conf.level}{overall confidence level of the likelihood intervals. Uses Bonferroni correction.}
}
\value{
An S3 class containing the test statistic, p value, list of likelihood based confidence intervals,
overall confidence level, individual confidence level of each interval and alternative
hypothesis.
}
\description{
Test equality of shape 2s of beta distributions.
}
\details{
\itemize{
\item Null: All shape2s are equal. (shape2_1 = shape2_2 ... shape2_k).
\item Alternative: At least one shape2 is not equal.
}
}
\examples{
library(LRTesteR)

# Null is true
set.seed(1)
x <- rbeta(150, 2, 2)
fctr <- c(rep(1, 50), rep(2, 50), rep(3, 50))
fctr <- factor(fctr, levels = c("1", "2", "3"))
beta_shape2_one_way(x, fctr, .95)

# Null is false
set.seed(1)
x <- c(rbeta(50, 2, 1), rbeta(50, 2, 2), rbeta(50, 2, 3))
fctr <- c(rep(1, 50), rep(2, 50), rep(3, 50))
fctr <- factor(fctr, levels = c("1", "2", "3"))
beta_shape2_one_way(x, fctr, .95)
}
