\name{LRcontrast-package}
\alias{LRcontrast-package}
\alias{LRcontrast}
\docType{package}
\title{
Dose Response Signal Detection under Model Uncertainty
}
\description{
Provides functions for calculating test statistics, simulating quantiles 
and simulating p-values of likelihood ratio contrast tests in regression 
models with a lack of identifiability.
}
\details{
\tabular{ll}{
Package: \tab LRcontrast\cr
Type: \tab Package\cr
Version: \tab 1.0\cr
Date: \tab 2015-06-21\cr
License: \tab GPL-3\cr
}
The main functions are: \cr
\bold{qLRcontrast}: Simulates quantiles of likelihood ratio contrast tests \cr
\bold{sLRcontrast}: Calculates test statistics of likelihood ratio contrast tests \cr
\bold{pLRcontrast}: Simulates p-values of likelihood ratio contrast tests
}
\author{
Kevin Kokot

Maintainer: Kevin Kokot <kevin.kokot@ruhr-uni-bochum.de>
}
\references{
Dette, H., Titoff, S., Volgushev, S. and Bretz, F. (2015), Dose
response signal detection under model uncertainty. Biometrics. doi:
10.1111/biom.12357
}
\keyword{ package }
\seealso{
\code{\link[DoseFinding:DoseFinding-package]{DoseFinding}}
}
\examples{
# Simulate the 90%, 95% and 99% quantiles of the LR contrast tests where the specified 
# models are competing against each other.
# The size of each dose group is equal in this case.

qLRcontrast(dose = c(0, 0.05, 0.2, 0.6, 1), probs = c(0.9, 0.95, 0.99), weight 
            = c(0.2, 0.2, 0.2, 0.2, 0.2), models = c("linear", "emax", 
            "exponential", "linlog"), nsim = 10)

# Calculate the LR test statistics with the same underlying models.
# In this case the data is generated by the constant model, i.e. the 
# null hypothesis of no dose response is true.

resp <- rnorm(n = 50, mean = 0.2)
dose <- c(rep(0, 10), rep(0.05, 10), rep(0.2, 10), rep(0.6, 10), rep(1, 10))

sLRcontrast(dose = dose, resp = resp, models = c("linear", "emax", "exponential", "linlog"))
			 
# Calculate the p-values in this scenario
			 
pLRcontrast(dose = dose, resp = resp, models = c("linear", "emax", "exponential", "linlog"), 
            nsim = 10)
}
