% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fill.R
\name{fill}
\alias{fill}
\title{Fill in Missing Values}
\usage{
fill(x, resetWhen = rep(FALSE, length(x)))
}
\arguments{
\item{x}{A vector, can be character, numeric, or logical.}

\item{resetWhen}{A logical vector, the same length as \code{x}, indicating elements that
should not be filled in.}
}
\value{
A vector the same length as \code{x}, with all NAs or ""s replaced by
  the last value for the vector.
  Note that and missing values at the beginning of the vector will not
  be replaced.
}
\description{
Fill in missing values in a vector, using the last recorded value.
}
\details{
Similar to \code{\link[zoo]{na.locf}} in the \code{zoo} package,
  but works for "" in character vectors as well.
}
\examples{
numvec <- c(NA, 1:5, NA, NA, NA, 10:12, NA)
newgroup <- c(1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0)
fill(numvec)
fill(numvec, newgroup)

charvec <- c("", letters[1:5], "", "", "", letters[10:12], "")
fill(charvec)
}

