% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setoutput_LWFB90.R
\name{set_outputLWFB90}
\alias{set_outputLWFB90}
\title{Select output for LWF-Brook90}
\usage{
set_outputLWFB90(output = NULL, edit = FALSE)
}
\arguments{
\item{output}{optional \code{[7,5]}-matrix, which is opened on R's
data-editor if \code{edit = TRUE}. If no matrix is passed, a default
selection of output values is returned opened in R's data-editor.}

\item{edit}{open R's data-editor ?}
}
\value{
a \code{[7,5]}-matrix containing \code{0} and \code{1} for use as
  \code{output}-argument in \code{\link{run_LWFB90}}
}
\description{
Returns a \code{[7,5]} matrix with a default selection of LWF-Brook90 output
data sets for the use as 'output'-argument \code{\link{run_LWFB90}}.
}
\examples{
# create matrix with default selection
output <- set_outputLWFB90()
output

# modify
output[,] <- 0L
output[,3] <- 1L
output["Evap", c("Ann","Mon")] <- 1L
output
}
