% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stateprobs.R
\name{stateprobs}
\alias{stateprobs}
\title{Calculate conditional local state probabilities for homogeneous HMMs}
\usage{
stateprobs(delta, Gamma, allprobs)
}
\arguments{
\item{delta}{Initial or stationary distribution of length N}

\item{Gamma}{Transition probability matrix of dimension c(N,N)}

\item{allprobs}{Matrix of state-dependent probabilities/ density values of dimension c(n, N)}
}
\value{
Matrix of conditional state probabilities of dimension c(n,N)
}
\description{
Computes \cr \cr
\eqn{\Pr(S_t = j \mid X_1, ..., X_T)} \cr \cr
}
\examples{
Gamma = tpm(c(-1,-2))
delta = stationary(Gamma)
allprobs = matrix(runif(200), nrow = 100, ncol = 2)

probs = stateprobs(delta, Gamma, allprobs)
}
