% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stationary_functions.R
\name{stationary}
\alias{stationary}
\title{Compute the stationary distribution of a homogeneous Markov chain}
\usage{
stationary(Gamma)
}
\arguments{
\item{Gamma}{transition probability matrix of dimension \code{c(N,N)} or array of such matrices of dimension \code{c(N,N,nTracks)} if the stationary distribution should be computed for several matrices at once}
}
\value{
either a single stationary distribution of the Markov chain (vector of length \code{N}) or a matrix of stationary distributions of dimension \code{c(nTracks,N)} with one stationary distribution in each row
}
\description{
A homogeneous, finite state Markov chain that is irreducible and aperiodic converges to a unique stationary distribution, here called \eqn{\delta}.
As it is stationary, this distribution satisfies
\deqn{\delta \Gamma = \delta,} subject to \eqn{\sum_{j=1}^N \delta_j = 1},
where \eqn{\Gamma} is the transition probability matrix. 
This function solves the linear system of equations above.
}
\examples{
# single matrix
Gamma = tpm(c(rep(-2,3), rep(-3,3)))
delta = stationary(Gamma)
# multiple matrices
Gamma = array(Gamma, dim = c(3,3,10))
Delta = stationary(Gamma)
}
\seealso{
\code{\link{tpm}} to create a transition probabilty matrix using the multinomial logistic link (softmax)

Other stationary distribution functions: 
\code{\link{stationary_cont}()},
\code{\link{stationary_p}()}
}
\concept{stationary distribution functions}
