% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Soddy.R
\name{Soddy}
\alias{Soddy}
\title{Finds the inner and outer Soddy circles of three given mutually tangent circles}
\usage{
Soddy(A, r1, B, r2, C, r3)
}
\arguments{
\item{A}{Vector containing the xy-coordinates of the center of circumference 1}

\item{r1}{Radius for circumference 1}

\item{B}{Vector containing the xy-coordinates of the center of circumference 2}

\item{r2}{Radius for circumference 2}

\item{C}{Vector containing the xy-coordinates of the center of circumference 3}

\item{r3}{Radius for circumference 3}
}
\value{
A list which contains the Soddy center and the radiuses of Soddy inner and outer circle of three mutually tangent circles
}
\description{
\code{Soddy} finds inner and outer Soddy circles of three given mutually tangent circles
}
\examples{
x_min <- -3
x_max <- 3
y_min <- -2.5
y_max <- 3.5
CoordinatePlane(x_min, x_max, y_min, y_max)
A <- c(-1,0)
B <- c(1,0)
C <- c(0,sqrt(3))
r1 <- 1
r2 <- 1
r3 <- 1
Draw(CreateArcAngles(A, r1, 0, 360), "black")
Draw(CreateArcAngles(B, r2, 0, 360), "black")
Draw(CreateArcAngles(C, r3, 0, 360), "black")
result <- Soddy(A, r1, B, r2, C, r3)
soddy_point <- result[[1]]
inner_radius <- result[[2]]
outer_radius <- result[[3]]
Draw(soddy_point,"red")
Draw(CreateArcAngles(soddy_point,inner_radius,0,360),"red")
Draw(CreateArcAngles(soddy_point,outer_radius,0,360),"red")
}
\references{
http://mathworld.wolfram.com/SoddyCircles.html
}
